/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.astar.AStar;
import cz.cuni.astar.AStarResult;
import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.GameMapAStarGoal;
import cz.cuni.pogamut.Client.GameMapAStarMap;
import cz.cuni.pogamut.Client.GameMapSettings;
import cz.cuni.pogamut.Client.ItemDistance;
import cz.cuni.pogamut.Client.Navigation;
import cz.cuni.pogamut.Client.PathManager;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.communication.CommunicationState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameMap
implements RcvMsgListener,
Navigation {
    protected Logger platformLog;
    private AgentBody body = null;
    protected AgentMemory memory = null;
    private Item nextItem = null;
    private int nextItemIndex = 0;
    public PathManager pathManager = null;
    int tempCounter = 0;

    public GameMap(Logger logger, AgentBody body, AgentMemory memory) {
        this.platformLog = logger;
        this.body = body;
        this.pathManager = new PathManager(this, body, logger);
        this.memory = memory;
        this.body.addRcvMsgListener((RcvMsgListener)this, EnumSet.of(MessageType.SPAWN));
    }

    @Override
    public ArrayList<Item> nearestHealth(int strength, int numberOfHealths) {
        ArrayList<Health> candidates = this.memory.getKnownHealths();
        ArrayList<Health> processedCandidates = new ArrayList<Health>();
        for (Health health : candidates) {
            if (health.strength < strength) continue;
            processedCandidates.add(health);
        }
        ArrayList<ItemDistance> res = new ArrayList<ItemDistance>();
        AStarResult aStarResult = null;
        for (Health health : processedCandidates) {
            aStarResult = this.getPathAStar(health.navPoint);
            if (!aStarResult.success) continue;
            res.add(new ItemDistance(health, aStarResult.getDistanceToGoal()));
        }
        Collections.sort(res);
        ArrayList<Item> result = new ArrayList<Item>();
        for (int i = 0; i < res.size() && i < numberOfHealths; ++i) {
            result.add(((ItemDistance)res.get((int)i)).item);
        }
        return result;
    }

    @Override
    public ArrayList<Item> nearestItems(MessageType type, int numberOfItems) {
        ArrayList<Item> candidates = this.memory.getKnownItemsOfType(type);
        ArrayList<ItemDistance> res = new ArrayList<ItemDistance>();
        AStarResult aStarResult = null;
        for (Item item : candidates) {
            aStarResult = this.getPathAStar(item.navPoint);
            if (!aStarResult.success) continue;
            res.add(new ItemDistance(item, aStarResult.getDistanceToGoal()));
        }
        Collections.sort(res);
        ArrayList<Item> result = new ArrayList<Item>();
        for (int i = 0; i < res.size() && i < numberOfItems; ++i) {
            result.add(((ItemDistance)res.get((int)i)).item);
        }
        return result;
    }

    @Override
    public NavPoint nearestNavPoint(Triple from) {
        return this.nearestNavPoint(from, 0);
    }

    @Override
    public NavPoint nearestNavPoint(Triple from, int minDistance) {
        double distance;
        ArrayList<MessageObject> candidates = this.body.knownObjects.getObjectsOfType(MessageType.NAV_POINT);
        double currentDistance = distance = Double.MAX_VALUE;
        NavPoint closest = null;
        NavPoint temp = null;
        for (MessageObject candidate : candidates) {
            temp = (NavPoint)candidate;
            if (temp.location == null || !(distance > (currentDistance = Triple.distanceInSpace(temp.location, from))) || !((double)minDistance < currentDistance)) continue;
            distance = currentDistance;
            closest = temp;
        }
        return closest;
    }

    public boolean atLocation(Triple location) {
        return Triple.distanceInSpace(location, this.memory.getAgentLocation()) < 10.0;
    }

    public boolean atLocation(Triple location, int epsilon) {
        return Triple.distanceInSpace(location, this.memory.getAgentLocation()) < (double)epsilon;
    }

    @Override
    public void sendGetPathToNavPoint(NavPoint toWhat) {
        this.body.getPath(toWhat.getLocation(), toWhat.ID);
    }

    @Override
    public void sendGetPathToLocation(int ID, Triple toWhat) {
        this.body.getPath(toWhat, ID);
    }

    @Override
    public ArrayList<NavPoint> getPathOfID(int ID) {
        return this.pathManager.getPath(String.valueOf(ID));
    }

    @Override
    public AStarResult getPathAStar(NavPoint toWhat, int maxNumOfIterations) {
        if (toWhat == null) {
            return null;
        }
        GameMapAStarGoal goal = new GameMapAStarGoal(toWhat);
        GameMapAStarMap map = new GameMapAStarMap();
        NavPoint start = new NavPoint();
        start.location = this.memory.getAgentLocation();
        start.neighbours = new ArrayList();
        ArrayList<NavPoint> nvs = this.memory.seeAllNavPoints();
        for (int i = 0; i < nvs.size(); ++i) {
            if (!nvs.get((int)i).reachable) continue;
            NeighNav nn = new NeighNav();
            nn.neighbour = nvs.get(i);
            start.neighbours.add(nn);
        }
        assert (goal != null);
        assert (map != null);
        assert (start != null);
        return AStar.aStar(goal, map, start, maxNumOfIterations);
    }

    @Override
    public ArrayList<NavPoint> getNavPointsAStar(AStarResult result) {
        if (result.success) {
            ArrayList path = result.getPath();
            ArrayList<NavPoint> navPoints = new ArrayList<NavPoint>();
            for (Object pathNode : path) {
                if (pathNode instanceof NavPoint) {
                    navPoints.add((NavPoint)pathNode);
                    continue;
                }
                if (pathNode instanceof NeighNav) {
                    navPoints.add(((NeighNav)pathNode).neighbour);
                    continue;
                }
                this.platformLog.severe("Wrong object in the A* path (" + pathNode.toString() + ").");
            }
            return navPoints;
        }
        return null;
    }

    @Override
    public AStarResult getPathAStar(NavPoint toWhat) {
        AStarResult result = this.getPathAStar(toWhat, -1);
        if (!result.success) {
            this.platformLog.info("PATH A*: failed unable to get path A Star");
        }
        return result;
    }

    @Override
    public void receiveMessage(RcvMsgEvent e) {
        if (e.getCommunicationState() != CommunicationState.BOT_RUNNING) {
            return;
        }
        switch (e.getMessage().type) {
            case SPAWN: {
                this.restartMap();
                break;
            }
            default: {
                this.platformLog.warning("Unexpected message!!!");
            }
        }
    }

    public void initializeGetPath() {
    }

    public ArrayList<NavPoint> getPathToLocation(Triple location) {
        if (this.pathManager.retrievePathGB(location) == PathManager.PathResult.PATH_FOUND) {
            return this.pathManager.getPath();
        }
        return null;
    }

    @Override
    public boolean runAlongPath() {
        return this.pathManager.runAlongPath() == PathManager.RunResult.RUNNING_ALONG;
    }

    @Override
    public void runAroundItemsInTheMap(List<? extends Item> itemsToRunAround, boolean AStar2) {
        if (itemsToRunAround.size() == 0) {
            this.platformLog.warning("no items to run around!!!");
            return;
        }
        if (this.nextItem == null) {
            this.platformLog.fine("TOTAL RESTART OF RUN AROUND ITEMS IN MAP");
            Collections.shuffle(itemsToRunAround);
            this.nextItem = itemsToRunAround.get(0);
            this.nextItemIndex = 0;
            return;
        }
        if (this.safeRunToLocation(this.nextItem.location)) {
            return;
        }
        if (++this.nextItemIndex < itemsToRunAround.size()) {
            this.nextItem = itemsToRunAround.get(this.nextItemIndex);
            this.platformLog.info("SWITCHING - running to another item in the list. \nNext item is: " + this.nextItem.cls);
        } else {
            this.nextItem = null;
        }
    }

    public void restartMap() {
        this.nextItem = null;
        this.nextItemIndex = 0;
        this.pathManager.restartPathManager();
    }

    public boolean antiStuckCheck(Triple goal) {
        Triple velocity = this.memory.getAgentVelocity();
        Triple location = this.memory.getAgentLocation();
        Triple nextPosition = Triple.add(velocity, location);
        double distanceDifference = Triple.vectorSize(Triple.subtract(goal, location));
        if ((distanceDifference -= Triple.vectorSize(Triple.subtract(goal, nextPosition))) < (double)GameMapSettings.distanceDifference) {
            this.platformLog.finest("DIFFERENCE " + this.tempCounter);
            ++this.tempCounter;
            return true;
        }
        if (Triple.vectorSize(velocity) < (double)GameMapSettings.minimalVelocity) {
            this.platformLog.finest("VELO " + Triple.vectorSize(velocity));
            return true;
        }
        if (goal.z - location.z > (double)GameMapSettings.heightLevel) {
            this.platformLog.finest("HIGH HIGH HIGH HIGH ");
            return true;
        }
        return false;
    }

    @Override
    public boolean safeRunToLocation(Triple location) {
        PathManager.PathResult pathResult = this.pathManager.retrievePathGB(location);
        if (pathResult == PathManager.PathResult.PATH_FOUND) {
            return this.pathManager.runAlongPath() == PathManager.RunResult.RUNNING_ALONG;
        }
        return pathResult == PathManager.PathResult.OBTAINING_PATH;
    }
}

