/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.NeighNavFlag;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloydWarshallMap {
    public static final int BAD_EDGE_FLAG = NeighNavFlag.FLY.get() | NeighNavFlag.LADDER.get() | NeighNavFlag.PROSCRIBED.get() | NeighNavFlag.SWIM.get() | NeighNavFlag.PLAYERONLY.get() | NeighNavFlag.FORCED.get();
    protected int badEdgeFlag = 0;
    protected Map<Integer, Integer> navPointIndices;
    protected Map<Integer, NavPoint> indicesNavPoints;
    protected PathMatrixNode[][] pathMatrix;
    private Logger log;

    public FloydWarshallMap(List<NavPoint> map, Logger log) {
        this(map, BAD_EDGE_FLAG, log);
    }

    public FloydWarshallMap(List<NavPoint> map, int badEdgeFlag, Logger log) {
        int i;
        log.info(this + ": Beginning Floyd-Warshall algorithm...");
        long start = System.currentTimeMillis();
        this.log = log;
        this.badEdgeFlag = badEdgeFlag;
        List<NavPoint> navPoints = map;
        int size = navPoints.size();
        this.navPointIndices = new HashMap<Integer, Integer>(size);
        this.indicesNavPoints = new HashMap<Integer, NavPoint>(size);
        this.pathMatrix = new PathMatrixNode[size][size];
        for (i = 0; i < navPoints.size(); ++i) {
            this.navPointIndices.put(navPoints.get((int)i).ID, i);
            this.indicesNavPoints.put(i, navPoints.get(i));
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.pathMatrix[i][j] = new PathMatrixNode(i == j ? 0.0 : Double.POSITIVE_INFINITY);
            }
        }
        for (i = 0; i < size; ++i) {
            NavPoint navPoint = navPoints.get(i);
            Triple location = navPoint.getLocation();
            if (navPoint.neighbours == null) {
                System.out.println("ouch");
            }
            for (NeighNav link : navPoint.neighbours) {
                if (!this.checkLink(navPoint, link)) continue;
                this.pathMatrix[i][this.navPointIndices.get(link.neighbour.ID)].setDistance(Triple.distanceInSpace(location, link.neighbour.getLocation()));
            }
        }
        log.info(this + ": navpoints count = " + navPoints.size());
        log.info(this + ": 1 / " + size);
        for (int k = 0; k < size; ++k) {
            if (k % 100 == 0) {
                log.info(this + ": " + (k + 1) + " / " + size);
            }
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j = 0; j < size; ++j) {
                    double newLen = this.pathMatrix[i2][k].getDistance() + this.pathMatrix[k][j].getDistance();
                    if (!(this.pathMatrix[i2][j].getDistance() > newLen)) continue;
                    this.pathMatrix[i2][j].setDistance(newLen);
                    this.pathMatrix[i2][j].setViaNode(k);
                }
            }
        }
        log.info(this + ": " + size + " / " + size);
        log.info(this + ": computation for " + size + " navpoints took " + (System.currentTimeMillis() - start) + " millis");
    }

    public boolean checkLink(NavPoint from, NeighNav edge) {
        if ((edge.flags & this.badEdgeFlag) != 0) {
            return false;
        }
        if ((edge.flags & NeighNavFlag.SPECIAL.get()) != 0) {
            return true;
        }
        if (Triple.distanceInSpace(from.getLocation(), edge.neighbour.getLocation()) < from.getLocation().z - edge.neighbour.getLocation().z && Triple.distanceInSpace(from.getLocation(), edge.neighbour.getLocation()) > 100.0) {
            return false;
        }
        return (edge.flags & NeighNavFlag.JUMP.get()) == 0 || !(from.getLocation().z - edge.neighbour.getLocation().z > 80.0);
    }

    protected List<NavPoint> retrievePathInner(Integer from, Integer to) {
        PathMatrixNode node = this.pathMatrix[from][to];
        if (node.getDistance() == Double.POSITIVE_INFINITY) {
            return null;
        }
        if (node.getViaNode() == null) {
            return new ArrayList<NavPoint>(0);
        }
        if (node.getViaNode() == null) {
            return new ArrayList<NavPoint>(0);
        }
        ArrayList<NavPoint> path = new ArrayList<NavPoint>();
        path.addAll(this.retrievePathInner(from, node.getViaNode()));
        path.add(this.indicesNavPoints.get(node.getViaNode()));
        path.addAll(this.retrievePathInner(node.getViaNode(), to));
        return path;
    }

    protected List<NavPoint> retrievePath(Integer from, Integer to) {
        ArrayList<NavPoint> path = new ArrayList<NavPoint>();
        path.add(this.indicesNavPoints.get(from));
        path.addAll(this.retrievePathInner(from, to));
        path.add(this.indicesNavPoints.get(to));
        return path;
    }

    protected PathMatrixNode getPathMatrixNode(NavPoint np1, NavPoint np2) {
        return this.pathMatrix[this.navPointIndices.get(np1.ID)][this.navPointIndices.get(np2.ID)];
    }

    public boolean reachable(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return false;
        }
        return this.getPathMatrixNode(from, to).getDistance() != Double.POSITIVE_INFINITY;
    }

    public double getDistance(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getPathMatrixNode(from, to).getDistance();
    }

    public List<NavPoint> getPath(NavPoint from, NavPoint to) {
        if (from == null || to == null) {
            return null;
        }
        PathMatrixNode node = this.getPathMatrixNode(from, to);
        if (node.distance == Double.POSITIVE_INFINITY) {
            return null;
        }
        List<NavPoint> path = node.getPath();
        if (path != null) {
            return path;
        }
        path = this.retrievePath(this.navPointIndices.get(from.ID), this.navPointIndices.get(to.ID));
        node.setPath(path);
        return path;
    }

    public String toString() {
        return "FloydWarshallMap";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathMatrixNode {
        private double distance = Double.POSITIVE_INFINITY;
        private Integer viaNode = null;
        private SoftReference<List<NavPoint>> path = null;

        public PathMatrixNode() {
        }

        public PathMatrixNode(double distance) {
            this.distance = distance;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }

        public Integer getViaNode() {
            return this.viaNode;
        }

        public void setViaNode(Integer indice) {
            this.viaNode = indice;
        }

        public List<NavPoint> getPath() {
            return this.path != null ? this.path.get() : null;
        }

        public void setPath(List<NavPoint> path) {
            this.path = new SoftReference<List<NavPoint>>(path);
        }
    }
}

