/*
 * Decompiled with CFR 0.152.
 */
package pogamutjavabot;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.FloydWarshallMap;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.FlagInfo;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.TeamChat;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.introspection.PogProp;

public class Main
extends Agent {
    private DieListener dieListener = new DieListener();
    private ChatListener chatListener = new ChatListener();
    FloydWarshallMap map = null;
    @PogProp
    public boolean kecej = false;
    @PogProp
    public boolean ctf = false;
    public int target = 1;
    private String[] msgs = new String[]{"ahoj", "nazdar", "cau"};
    NavPoint redBase = null;
    NavPoint blueBase = null;
    NavPoint enemyBase = null;
    NavPoint myBase = null;

    @Override
    protected void doLogic() {
        FlagInfo flag = this.memory.getEnemyFlag();
        if (flag == null) {
            this.body.sendGlobalMessage("flag is null");
            this.body.sendGlobalMessage("nevim, bezim do nepratelske baze");
            this.gameMap.safeRunToLocation(this.enemyBase.location);
            return;
        }
        if (flag.team == 1) {
            this.body.sendGlobalMessage("tym: blue");
        } else if (flag.team == 0) {
            this.body.sendGlobalMessage("tym: red");
        } else {
            this.body.sendGlobalMessage("tym: neznamy???");
        }
        if (this.memory.getMyFlag() != null) {
            this.body.sendGlobalMessage("my flag state: " + this.memory.getMyFlag().state);
        }
        this.body.sendGlobalMessage("Flag at: " + flag.location);
        if (flag.holderID == this.memory.getAgentID()) {
            this.body.sendGlobalMessage("drzim vlajku!");
            this.gameMap.safeRunToLocation(this.myBase.location);
            return;
        }
        if (flag.isVisible() && flag.location != null) {
            this.body.sendGlobalMessage("vidim vlajku");
            if (!this.gameMap.safeRunToLocation(flag.location)) {
                this.body.runToLocation(flag.location);
            }
            return;
        }
        this.body.sendGlobalMessage("nevidim vlajku, bezim do nepratelske baze");
        if (!this.gameMap.safeRunToLocation(this.enemyBase.location)) {
            this.body.turnHorizontal(30);
        }
    }

    private boolean atLocation(Triple location) {
        double distance = Triple.distanceInPlane(this.memory.getAgentLocation(), location);
        this.body.sendGlobalMessage("distance = " + distance);
        return distance < 80.0;
    }

    @Override
    protected void prePrepareAgent() throws PogamutException {
        this.body.addTypedRcvMsgListener(this.dieListener, MessageType.BOT_KILLED);
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
        for (NavPoint nav : this.memory.getKnownNavPoints()) {
            if (this.redBase == null && nav.UnrealID.contains("RedFlagBase")) {
                this.redBase = nav;
                this.log.info("Red base: " + nav);
            } else if (nav.UnrealID.contains("BlueFlagBase")) {
                this.blueBase = nav;
                this.log.info("Blue base: " + nav);
            }
            if (this.redBase == null || this.blueBase == null) continue;
            break;
        }
        boolean myTeam = true;
        if (this.memory.getGameInfo().gameType.contains("CTF")) {
            int blue;
            int red = this.memory.getPlayerCount(0);
            if (red > (blue = this.memory.getPlayerCount(1))) {
                this.body.initializer.setTeam(1);
                this.target = 0;
                myTeam = true;
            } else if (red < blue) {
                this.body.initializer.setTeam(0);
                this.target = 1;
                myTeam = false;
            } else if (this.random.nextInt(2) == 0) {
                this.body.initializer.setTeam(0);
                this.target = 1;
                myTeam = false;
            } else {
                this.body.initializer.setTeam(1);
                this.target = 0;
                myTeam = true;
            }
        }
        if (myTeam) {
            this.enemyBase = this.redBase;
            this.myBase = this.blueBase;
        } else {
            this.enemyBase = this.blueBase;
            this.myBase = this.redBase;
        }
        this.body.addTypedRcvMsgListener(this.chatListener, MessageType.TEAM_CHAT);
        this.map = new FloydWarshallMap(this.memory.getKnownNavPoints(), this.log);
    }

    @Override
    protected void shutdownAgent() throws PogamutException {
    }

    public static void main(String[] args) {
    }

    private class ChatListener
    implements RcvMsgListener {
        private ChatListener() {
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            Main.this.body.sendGlobalMessage(Main.this.memory.getAgentName() + " - " + ((TeamChat)e.getMessage()).string);
        }
    }

    private class DieListener
    implements RcvMsgListener {
        private DieListener() {
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            Main.this.body.sendGlobalMessage("Umrel jsem!");
        }
    }
}

