<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : MessageTransformer.xslt.xml
    Created on : 17. březen 2008, 10:53
    Author     : ik
    Description:
        Transforms the MessageObjectsList.xml file fo set of Java wrappers for 
        the GB messages.
-->
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  version="2.0">
    <xsl:output method="text" indent="yes"/>
   

  <!--<xsl:include href="../../../../../../tools/docbook-xsl-1.73.2/xhtml/docbook.xsl"/>!-->
  <!--<xsl:include href="../../../../../../tools/docbook-xsl2-snapshot/base/html/html.xsl"/>!-->
 
    <!-- target directory for java files. !-->
    <xsl:variable name="commandsJavaDir">../gbcommands/</xsl:variable> 
    <xsl:variable name="infoJavaDir">../gbinfomessages/</xsl:variable>
    
    <xsl:template name="addInterfaces">
    	<!-- Can be "", mustn't start or end with ',' -->
    	<xsl:param name="interfaces"/>
    	<!-- Can be "", mustn't start or end with ','  -->
    	<xsl:param name="interfacesToAdd"/>
    	
    	<xsl:choose>
	    	<xsl:when test="normalize-space($interfaces) = ''">
	    		<xsl:choose>
		    		<xsl:when test="normalize-space($interfacesToAdd) = ''">
		    			<xsl:value-of></xsl:value-of>
		    		</xsl:when>
		    		<xsl:otherwise>
		    			<xsl:value-of select="$interfacesToAdd"/>
		    		</xsl:otherwise>
		    	</xsl:choose>
	    	</xsl:when>
	    	<xsl:otherwise>
	    		<xsl:choose>
		    		<xsl:when test="normalize-space($interfacesToAdd) = ''">
		    			<xsl:value-of select="$interfaces"/>
		    		</xsl:when>
		    		<xsl:otherwise>    		
		    			<xsl:value-of select="concat($interfaces, ', ', $interfacesToAdd)"/>
		    		</xsl:otherwise>
		    	</xsl:choose>
	    	</xsl:otherwise>
	    </xsl:choose>
    </xsl:template>
           
    <!-- Template translating message objects to java files. !-->
    <xsl:template match="//messageobject|//commandobject">
    	<xsl:choose>
    		<xsl:when test="local-name() = 'messageobject'">
    			<xsl:call-template name="messageobject">
    				<xsl:with-param name="filename" select="concat($infoJavaDir, @name,'.java')" />
    			</xsl:call-template>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="messageobject">
    				<xsl:with-param name="filename" select="concat($commandsJavaDir, @name,'.java')" />
    			</xsl:call-template>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template match="/">
    	<xsl:result-document href="{concat($infoJavaDir, 'InfoMessages.java')}" method="text" indent="yes">
    	
    		/**
            IMPORTANT !!!
       
            DO NOT EDIT THIS FILE. IT IS GENERATED FROM approriate xml file in BY
            THE JavaClassesGenerator.xslt. MODIFY THAT FILE INSTEAD OF THIS ONE.
       
            IMPORTANT END !!!
            */
            package <xsl:value-of select="/messages/settings/javasettings/javapackageinfomessages/@package"/>;
            
            <xsl:call-template name="fillImports"/>   
            
            /**
             * Serves for the purpose of testing the parser. Warning - first item in PROTOTYPES is null!
             */
            public class InfoMessages {
            	public static final String[] PROTOTYPES = 
            		new String[]{
            			null // dummy 
            			<xsl:for-each select="//messageobject">
            			
            				<xsl:text>,</xsl:text>
            				<xsl:value-of select="@name"/><xsl:text>.PROTOTYPE</xsl:text>
            			</xsl:for-each>
            		};
            		
            	/** Serves to initialize map */            		
            	private static final Map<![CDATA[<]]>String,Class<![CDATA[<]]>? extends InfoMessage>> prototypeMap = 
            		new HashMap<![CDATA[<]]>String,Class<![CDATA[<]]>? extends InfoMessage>>();
            		
            	/** Unmodifiable map message.PROTOTYPE -> message.class */	
           		public static final Map<![CDATA[<]]>String,Class<![CDATA[<]]>? extends InfoMessage>> PROTOTYPE_MAP;
            		
            	static {
            		<xsl:for-each select="//messageobject">
            			prototypeMap.put(<xsl:value-of select="@name"/>.PROTOTYPE, <xsl:value-of select="@name"/>.class); 
           			</xsl:for-each>
					PROTOTYPE_MAP = Collections.unmodifiableMap(prototypeMap);	
            	}
            }
            
            <xsl:apply-templates/>
    	
    	</xsl:result-document>
    </xsl:template>
    
    <xsl:template name="messageobject">
    	<xsl:param name="filename"/>
    	
    	<xsl:variable name="interfaces"></xsl:variable>
    	
        <xsl:result-document href="{$filename}" method="text" indent="yes">
            /**
            IMPORTANT !!!
       
            DO NOT EDIT THIS FILE. IT IS GENERATED FROM approriate xml file in <xsl:choose>
                      <xsl:when test="@command">xmlresources/gbcommands</xsl:when>
                      <xsl:when test="@message">xmlresources/gbinfomessages</xsl:when>
                      <xsl:otherwise>!ERROR!</xsl:otherwise>    
                  </xsl:choose> BY
            THE JavaClassesGenerator.xslt. MODIFY THESE FILES INSTEAD OF THIS ONE.
       
            IMPORTANT END !!!
            */
            package
            <xsl:choose>
	            <xsl:when test="local-name() = 'messageobject'">
	    			<xsl:value-of select="/messages/settings/javasettings/javapackageinfomessages/@package"/>;
	    		</xsl:when>
	    		<xsl:otherwise>
	    			<xsl:value-of select="/messages/settings/javasettings/javapackagecommands/@package"/>;
	    		</xsl:otherwise>
	    	</xsl:choose>
            
            
            <xsl:call-template name="fillImports"/>            
            <!-- Apply the Docbook to HTML transformation. !-->
            /**
              <xsl:apply-templates select="documentation"/>
              
              <p>
                  <xsl:choose>
                      <xsl:when test="@command">
                          Corresponding GameBots command is 
                          <code><xsl:value-of select="@command"/></code>.
                      </xsl:when>
                      <xsl:when test="@message">
                          Corresponding GameBots message is 
                          <code><xsl:value-of select="@message"/></code>.
                      </xsl:when>    
                  </xsl:choose> 
                  
              </p>
             */
            <xsl:for-each select="annotation">
            	@<xsl:value-of select="@name"/>
            </xsl:for-each> 
            <xsl:if test="@type = 'Synchronous'">
            	@SyncMessage
            </xsl:if>
            public class
            <xsl:value-of select="@name"/>
            
            <!--TODO polish the interfaces -->

            <xsl:choose>
                <xsl:when test="@type = 'Event'">
                    extends GBEvent
                </xsl:when>
                <xsl:when test="@type = 'ObjectUpdate'">
                    extends GBObjectUpdate
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="@extends"/>
                </xsl:otherwise>
            </xsl:choose>


            <!-- list of interfaces, some from the implements tag, some determined by
            the message type. !-->
            <xsl:variable name="interfaces2">
	            <xsl:choose>
		            <xsl:when test="@type='Event' or @type='Batch'">
		            	<xsl:call-template name="addInterfaces">
			            		<xsl:with-param name="interfaces" select="$interfaces"/>
			            		<xsl:with-param name="interfacesToAdd" select="'IWorldEvent'"/>
			            </xsl:call-template>                
		            </xsl:when>
		            <xsl:when test="@type='ObjectUpdate'">
		            	<xsl:call-template name="addInterfaces">
		            		<xsl:with-param name="interfaces" select="$interfaces"/>
		            		<xsl:with-param name="interfacesToAdd" select="'IGBWorldObjectEvent, IWorldObject'"/>
			            </xsl:call-template>                               
		            </xsl:when>
		            <xsl:otherwise>
		            	<xsl:value-of select="$interfaces"/>
		            </xsl:otherwise>
		        </xsl:choose>
		    </xsl:variable>
            <xsl:variable name="interfaces3">
            	<xsl:call-template name="addInterfaces">
            		<xsl:with-param name="interfaces" select="$interfaces2"/>
            		<xsl:with-param name="interfacesToAdd" select="./implements/@interfaces"/>
            	</xsl:call-template>
            </xsl:variable>
            <xsl:choose>
	            <xsl:when test="normalize-space($interfaces3) = ''">
	            </xsl:when>
	            <xsl:otherwise>
	            	implements <xsl:value-of select="$interfaces3"/>
	            </xsl:otherwise>
	        </xsl:choose>
                        
            {
            
            <!-- Generate constructor for Command objects. !-->
            <xsl:choose>
            	<xsl:when test="@command">
                	<xsl:call-template name="constructorCreator"/>
                </xsl:when>
                <xsl:otherwise>
                	<xsl:call-template name="prototypeCreator"/>
                </xsl:otherwise>
            </xsl:choose>
            
            /////// Properties BEGIN
            <xsl:apply-templates select="property"/>
            /////// Properties END
            
            /////// Extra Java code BEGIN
                        	
            	/////// Additional code from xslt BEGIN            	 
            		<xsl:if test="@type = 'ObjectUpdate'">
            		<!-- Now we have to check whether we have all informations
            		     IWorldObject interface requires (Id, lastSeenTime),
            		     if not -> add them manually
            	    -->
            			<xsl:choose>
            				<xsl:when test="./property[@name='Id']">
            				</xsl:when>
            				<xsl:otherwise>
            					public static final StringId <xsl:value-of select="@name"/>Id = new StringId("<xsl:value-of select="@name"/>Id");
            					
            					public StringId getId() {
            						return <xsl:value-of select="@name"/>Id;
            					}
            				</xsl:otherwise>
            			</xsl:choose>
            					
       					<xsl:choose>
       						<xsl:when test="./property[@name='Time']">
       							protected void setTime(double time) {
       								this.Time = time;
       							}
       						
       							public double getLastSeenTime() {
       								return Time;
       							}
       						</xsl:when>
       						<xsl:otherwise>
       							protected double Time = 0;
       							
       							protected double getTime() {
       								return Time;
       							}
       							
       							protected void setTime(double time) {
       								this.Time = time;
       							}
       						
       							public double getLastSeenTime() {
       								return Time;
       							}
       						</xsl:otherwise>
       					</xsl:choose>
       					
       					public boolean equals(Object obj) {
	                      if (!(obj instanceof <xsl:value-of select="@name"/>)) return false;
	                      <xsl:value-of select="@name"/> cast = (<xsl:value-of select="@name"/>)obj;
	                      if (this.getId() != null) return this.getId().equals(cast.getId());
	                      else return cast.getId() == null;
	                    }
	                    
	                    public int hashCode() {
	                      if (getId() != null) return getId().hashCode();
	                      return 0;
	                    }
            			
            		</xsl:if>	
            		
            		
            	/////// Additional code from xslt END            
				                    
	            /////// Extra Java from XML BEGIN
            		<xsl:value-of select="extra/code/java"/>
            	/////// Extra Java from XML END
            	    
            /////// Extra Java code END
            
            <!-- CUSTOM CODE !-->
            
            /**
              * Cloning constructor.
              */
             public <xsl:value-of select="@name"/>(<xsl:value-of select="@name"/> original) {
                <xsl:for-each select="property">
                     this.<xsl:value-of select="@name"/>=original.<xsl:value-of select="@name"/>;
                </xsl:for-each>
             }   
             
             <xsl:if test="not(@command)">
                 /**
                  * Used by Yylex to create empty message then to fill it's protected fields (Yylex is in the same package).
                  */
	             public <xsl:value-of select="@name"/>() {
	             }
             </xsl:if>
            
            <xsl:choose>
	    		<xsl:when test="@type = 'ObjectUpdate'">
	    		<xsl:if test="./property[@name='Visible']">
	    		
	    		     /**
	    		      * Used to drop Visible flag from the object.
	    		      */
	    		     public static class ObjectDisappeared implements IGBWorldObjectDisappeared {
	    		     
	    		         private IWorldObject orig;
	    		         
	    		         public ObjectDisappeared(IWorldObject orig) {
	    		             this.orig = orig;
	    		         }
	    		         
	    		         public IWorldObjectId getId() {
	    		             return orig.getId();
	    		         }
    
                         public IWorldObject update(IWorldObject obj) {
                            if (obj == null) {
                                throw new PogamutRuntimeException("not meant to create new object, probably wanted to update non-existing object of id: " + getId(), this);
                            }
                            if (!(obj instanceof <xsl:value-of select="@name"/>)) {
                                throw new PogamutRuntimeException("can't update object of class " + obj.getClass() + ", meant to update <xsl:value-of select="@name"/>", this);
                            } 
                            orig = obj;
                            <xsl:value-of select="@name"/> toUpdate = (<xsl:value-of select="@name"/>)obj;
                            toUpdate.Visible = false;
                            return toUpdate;
                         }
    
                         public IWorldObject getObject() {
                            return orig;
                         }
                         
                         public String toString() {
                            return "ObjectDisappeared[" + orig.getClass().getName().substring(getClass().getName().lastIndexOf(".")+1) + " " + orig.getId() + "]"; 
                         }
	    		         
	    		     }
	    		
	    		     /**
	    		      * Used to create event that drops the Visible flag of the item.
	    		      */
	    		     public <xsl:value-of select="@name"/>(<xsl:value-of select="@name"/> Original, boolean Visible) {
	    		         this(Original);
	    		         this.Visible = Visible;
	    		     }
	    		     
	    		     public IGBWorldObjectDisappeared createDisappearEvent() {
	    		         return new ObjectDisappeared(this);
	    		     }
	    		</xsl:if>
	    		
	    		/**
	    		 * Here we save the original object for which this object is an update.
	    		 */ 
	    		private IWorldObject orig = null;
	    		
	            public IWorldObject update(IWorldObject obj) {
		            if(obj == null) {
		               orig = this;
		               return this;
		            }
		            orig = obj;
		            // typecast
		            <xsl:value-of select="@name"/><xsl:text> </xsl:text> o = (<xsl:value-of select="@name"/>)obj;
		            
		            <xsl:for-each select="property[@volatile]">
		                o.<xsl:value-of select="@name"/>=<xsl:value-of select="@name"/>;
		            </xsl:for-each>
		            
		            <!--  If it is ObjectUpdate && we don't have property Time,
		            	  (that means the property Time is added by this XSLT),
		            	  put into update additional property Time
		             -->
		            <xsl:if test="@type = 'ObjectUpdate'">            	
		            	<xsl:choose>
							<xsl:when test="./property[@name='Time']">						
							</xsl:when>
							<xsl:otherwise>
								o.Time = Time;
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
		            
		            return o;
		        }
	        
	            /**
	             * Returns original object (if method update() has already been called, for bot-programmer that is always true
	             * as the original object is updated and then the event is propagated).
	             */ 
		        public IWorldObject getObject() {
		            if (orig == null) return this;
		            return orig;
		        }
	        </xsl:when>
        </xsl:choose>
                
                 <!-- toString method -->
            public String toString() {
                return
                <xsl:choose>
                	<xsl:when test="@message">
                		super.toString() + " | " +
                		<xsl:for-each select="property"> 
			                <xsl:if test="not(@jflex)">
				               "<xsl:value-of select="@name"/> = " + 
				               String.valueOf(<xsl:value-of select="@name"/>) + " | " +
				            </xsl:if>
	            		</xsl:for-each> "";
                	</xsl:when>
                    <xsl:when test="@command">
                    	super.toString();
                    </xsl:when>
                </xsl:choose> 
             }
             
             public String toHtmlString() {
                return super.toString() +
            <xsl:for-each select="property"> 
            "<![CDATA[<b>]]><xsl:value-of select="@name"/><![CDATA[</b>]]> : " + 
            String.valueOf(<xsl:value-of select="@name"/>) + 
            " <![CDATA[<br/>]]> " +
            </xsl:for-each> "";
             }            
             
             <!-- To GB string. Used for sending the command. !-->
             <xsl:if test="@command">
                 public String toMessage() {
              		StringBuffer buf = new StringBuffer();
              		buf.append("<xsl:value-of select="@command"/>");
              		<xsl:for-each select="property">
	              		<xsl:choose>
		    				<xsl:when test="@type = 'Boolean'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    					}    
		    				</xsl:when>
		    				<xsl:when test="@type = 'boolean'">
		    					buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    				</xsl:when>
		    				<xsl:when test="@type = 'Integer'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    					} 
		    				</xsl:when>
		    				<xsl:when test="@type = 'int'">
		    					buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    				</xsl:when>
		    				<xsl:when test="@type = 'Float'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'float'">
		    					buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    				</xsl:when>
		    				<xsl:when test="@type = 'Double'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'double'">
		    					buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    				</xsl:when>
		    				<xsl:when test="@type = 'Point3d'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + 
		    							<xsl:value-of select="@name"/>.getX() + "," + 
		    							<xsl:value-of select="@name"/>.getY() + "," + 
		    							<xsl:value-of select="@name"/>.getZ() + "}");
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Vector3d'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + 
		    							<xsl:value-of select="@name"/>.getX() + "," + 
		    							<xsl:value-of select="@name"/>.getY() + "," + 
		    							<xsl:value-of select="@name"/>.getZ() + "}");
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'Location'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " + 
                                        <xsl:value-of select="@name"/>.getX() + "," + 
                                        <xsl:value-of select="@name"/>.getY() + "," + 
                                        <xsl:value-of select="@name"/>.getZ() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Velocity'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " + 
                                        <xsl:value-of select="@name"/>.getX() + "," + 
                                        <xsl:value-of select="@name"/>.getY() + "," + 
                                        <xsl:value-of select="@name"/>.getZ() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Rotation'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> Y" + 
                                        <xsl:value-of select="@name"/>.getYaw() + ",R" + 
                                        <xsl:value-of select="@name"/>.getRoll() + ",P" + 
                                        <xsl:value-of select="@name"/>.getPitch() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Color'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " + 
                                        <xsl:value-of select="@name"/>.getRed() + "," + 
                                        <xsl:value-of select="@name"/>.getGreen() + "," + 
                                        <xsl:value-of select="@name"/>.getBlue() + "," +
                                        <xsl:value-of select="@name"/>.getAlpha() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Point2D'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " + 
                                        <xsl:value-of select="@name"/>.getX() + "," +
                                        <xsl:value-of select="@name"/>.getY() + "}");
                                }
                            </xsl:when>
                            <xsl:when test="@type = 'Dimension2D'">
                                if (<xsl:value-of select="@name"/> != null) {
                                    buf.append(" {<xsl:value-of select="@name"/> " + 
                                        <xsl:value-of select="@name"/>.getWidth() + "," +
                                        <xsl:value-of select="@name"/>.getHeight() + "}");
                                }
                            </xsl:when>
		    				<xsl:when test="@type = 'UnrealId'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/>.getUnrealId() + "}");
		    					}
		    				</xsl:when>
		    				<xsl:when test="@type = 'String'">
		    					if (<xsl:value-of select="@name"/> != null) {
		    						buf.append(" {<xsl:value-of select="@name"/> " + <xsl:value-of select="@name"/> + "}");
		    					}
		    				</xsl:when>
		    				<xsl:otherwise> unsupported type <xsl:value-of select="@type"/> </xsl:otherwise>
	    				</xsl:choose>
              		</xsl:for-each>            
            		return buf.toString();
            }
             </xsl:if>
             }
                         
        </xsl:result-document>
    </xsl:template>
    
    <xsl:template match="@extends"> extends
        <xsl:value-of select="."/>
    </xsl:template>
    
    <xsl:template match="property">
        /**
        <xsl:apply-templates select="documentation"/> */
        protected
        <xsl:text> </xsl:text>
        <xsl:value-of select="@type"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@name"/> = 
        	<xsl:choose>
        		<xsl:when test="@default">
        			<xsl:value-of select="@default"/>
        		</xsl:when>
        		<xsl:otherwise>
		       		<xsl:choose>
						<xsl:when test="@type = 'Boolean'">null</xsl:when>
						<xsl:when test="@type = 'boolean'">false</xsl:when>
						<xsl:when test="@type = 'Integer'">null</xsl:when>
						<xsl:when test="@type = 'int'">0</xsl:when>
						<xsl:when test="@type = 'Float'">null</xsl:when>
						<xsl:when test="@type = 'float'">0</xsl:when>
						<xsl:when test="@type = 'Double'">null</xsl:when>
						<xsl:when test="@type = 'double'">0</xsl:when>
						<xsl:when test="@type = 'Point3d'">null</xsl:when>
						<xsl:when test="@type = 'Vector3d'">null</xsl:when>
						<xsl:when test="@type = 'Location'">null</xsl:when>
						<xsl:when test="@type = 'Velocity'">null</xsl:when>
						<xsl:when test="@type = 'Rotation'">null</xsl:when>
						<xsl:when test="@type = 'UnrealId'">null</xsl:when>
						<xsl:when test="@type = 'ItemType'">null</xsl:when>
						<xsl:when test="@type = 'String'">null</xsl:when>
						<xsl:otherwise>null</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>;
        
        <!-- Getter !-->
        /**
        <xsl:apply-templates select="documentation"/> */
        public
        <xsl:value-of select="@type"/>
        <xsl:choose>
            <xsl:when test="@type='boolean'">
                <xsl:text> is</xsl:text>
            </xsl:when>
            <xsl:when test="@type='Boolean'">
                <xsl:text> is</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text> get</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:call-template name="uppercaseFirst">
            <xsl:with-param name="str" select="@name"/>
        </xsl:call-template>() {
            return
        <xsl:text> </xsl:text>
        <xsl:value-of select="@name"/>;
        }
        <!-- Setter !-->

        <xsl:if test="../@command">
            /**         
        <xsl:apply-templates select="documentation"/> */
        public <xsl:value-of select="../@name"/>
        <xsl:text> set</xsl:text>
        <xsl:call-template name="uppercaseFirst">
            <xsl:with-param name="str" select="@name"/>
        </xsl:call-template>(<xsl:value-of select="@type"/><xsl:text> </xsl:text><xsl:value-of select="@name"/>) {
            this.<xsl:value-of select="@name"/> = <xsl:value-of select="@name"/>;
            return this;
            }
       </xsl:if>
    </xsl:template>
    <xsl:template name="uppercaseFirst">
        <xsl:param name="str"/>
        <xsl:param name="strLen" select="string-length($str)"/>
        <xsl:variable name="firstLetter" select="substring($str,1,1)"/>
        <xsl:variable name="restString" select="substring($str,2,$strLen)"/>
        <xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
        <xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
        <xsl:variable name="translate" select="translate($firstLetter,$lower,$upper)"/>
        <xsl:value-of select="concat($translate,$restString)"/>
    </xsl:template>
    
    <!-- Generates prototype string with the message. -->
    <xsl:template name="prototypeCreator">
    	/** Example how the message looks like - used during parser tests. */
    	public static final String PROTOTYPE = 
    		"<xsl:value-of select="@message"/><xsl:for-each select="property"><xsl:if test="not(@jflex)"><xsl:text> {</xsl:text><xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:choose>
    				<xsl:when test="@type = 'Boolean'">False</xsl:when>
    				<xsl:when test="@type = 'boolean'">False</xsl:when>
    				<xsl:when test="@type = 'Integer'">0</xsl:when>
    				<xsl:when test="@type = 'int'">0</xsl:when>
    				<xsl:when test="@type = 'Float'">0</xsl:when>
    				<xsl:when test="@type = 'float'">0</xsl:when>
    				<xsl:when test="@type = 'Double'">0</xsl:when>
    				<xsl:when test="@type = 'double'">0</xsl:when>
    				<xsl:when test="@type = 'Point3d'">0,0,0</xsl:when>
    				<xsl:when test="@type = 'Vector3d'">0,0,0</xsl:when>
    				<xsl:when test="@type = 'Location'">0,0,0</xsl:when>
    				<xsl:when test="@type = 'Velocity'">0,0,0</xsl:when>
    				<xsl:when test="@type = 'Rotation'">0,0,0</xsl:when>
    				<xsl:when test="@type = 'UnrealId'">unreal_id</xsl:when>
    				<xsl:when test="@type = 'ItemType'">xWeapons.FlakCannonPickup</xsl:when>
    				<xsl:when test="@type = 'String'">text</xsl:when>
    				<xsl:otherwise>null</xsl:otherwise>
    			</xsl:choose><xsl:text>}</xsl:text></xsl:if></xsl:for-each>";
    </xsl:template>
    
    <xsl:template name="fillImports">
            <xsl:for-each select="/messages/settings/javasettings/javaimport">
                <xsl:call-template name="javaimport">
                    <xsl:with-param name="package" select="@import"/>
                </xsl:call-template>
            </xsl:for-each>
            <xsl:for-each select="extra/code/java/javaimport">
                <xsl:call-template name="javaimport">
                    <xsl:with-param name="package" select="@import"/>
                </xsl:call-template>
            </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="javaimport">
        <xsl:param name="package"/>
        <xsl:text>import </xsl:text>
                <xsl:value-of select="$package"/>;    
    </xsl:template>
    
    <!-- Docbook to HTML transformations. !-->
    <xsl:template match="para">
        <![CDATA[<p>]]>
            <xsl:apply-templates select="."/>
        <![CDATA[</p>]]>
    </xsl:template>
    
     <xsl:template match="itemizedlist">
        <![CDATA[<ul>]]>
            <xsl:apply-templates select="."/>
        <![CDATA[</ul>]]>
    </xsl:template>
    
    <xsl:template match="listitem">
         <![CDATA[<li>]]>
            <xsl:apply-templates select="."/>
        <![CDATA[</li>]]>
    </xsl:template>
    
     <xsl:template match="simplelist">
         <![CDATA[<ul>]]><xsl:apply-templates/><![CDATA[</ul>]]>
    </xsl:template>
    
        <xsl:template match="member">
     <![CDATA[<li>]]><xsl:apply-templates/><![CDATA[</li>]]>
    </xsl:template>
    
    <!-- Generates constructor for command objects. !-->
    <xsl:template name="constructorCreator">
            /**
              Creates new instance of command <xsl:value-of select="@name"/>.
              <xsl:apply-templates select="documentation"/>
              <p>Corresponding GameBots message for this command is 
              <code><xsl:value-of select="@command"/></code>.</p>
              
              <xsl:for-each select="property">
                  @param <xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:apply-templates select="documentation"/>
              </xsl:for-each>
              */
             public <xsl:value-of select="@name"/>(
                <xsl:for-each select="property">
                    <xsl:value-of select="@type"/><xsl:text> </xsl:text><xsl:value-of select="@name"/>
                     <xsl:if test="position() != last()">
                        <xsl:text>,  </xsl:text>
                     </xsl:if>
                </xsl:for-each>) {
                    <xsl:for-each select="property">
                    this.<xsl:value-of select="@name"/> = <xsl:value-of select="@name"/>;
                </xsl:for-each>
                }
               
            <xsl:if test="@command">
            	<xsl:if test="not(count(property) = 0)">
            		/**
		             Creates new instance of command <xsl:value-of select="@name"/>.
		             <xsl:apply-templates select="documentation"/>
		             <p>Corresponding GameBots message for this command is 
		             <code><xsl:value-of select="@command"/></code>.</p>
		             <xsl:text>
		             <![CDATA[<p></p>]]></xsl:text>
		             <b>WARNING:</b> this is empty-command constructor, you have to use setters to fill it up!
		             */
            		public  <xsl:value-of select="@name"/>() {
            		}
            	</xsl:if>
            </xsl:if>
    </xsl:template>
</xsl:stylesheet>

  
  
  