/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.listener;

import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import java.util.HashMap;
import java.util.Map;

public class ListenersMap<Key> {
    private Map<Key, Listeners<IListener>> listenersMap = new HashMap<Key, Listeners<IListener>>();
    private int listenersCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Key key, IListener listener) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            Listeners<IListener<Object>> listeners = this.listenersMap.get(key);
            if (listeners == null) {
                listeners = new Listeners();
                this.listenersMap.put(key, listeners);
            }
            listeners.addWeakListener(listener);
            ++this.listenersCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening(IListener listener) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            for (Key key : this.listenersMap.keySet()) {
                if (!this.isListening(key, listener)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening(Key key, IListener listener) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            Listeners<IListener> listeners = this.listenersMap.get(key);
            if (listeners == null) {
                return false;
            }
            return listeners.isEqualListening(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IListener listener) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            for (Key key : this.listenersMap.keySet()) {
                this.remove(key, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Key key, IListener listener) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            Listeners<IListener> listeners = this.listenersMap.get(key);
            if (listeners == null) {
                return;
            }
            this.listenersCount -= listeners.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Listeners.ListenerNotifier<IListener> notifier) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            for (Key key : this.listenersMap.keySet()) {
                this.notify(key, notifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Key key, Listeners.ListenerNotifier<IListener> notifier) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            Listeners<IListener> listeners = this.listenersMap.get(key);
            if (listeners == null) {
                return;
            }
            listeners.notify(notifier);
        }
    }

    public boolean hasListeners() {
        return this.listenersCount > 0;
    }
}

