/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.listener;

import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Listeners<Listener extends EventListener> {
    private ConcurrentLinkedQueue<ListenerStore<Listener>> listeners = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStrongListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listeners.addStrongListener(): can't add 'null' as a listener");
        }
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            this.listeners.add(new StrongListenerStore<Listener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWeakListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listeners.addWeakListener(): can't add 'null' as a listener");
        }
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            this.listeners.add(new WeakListenerStore<Listener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEqualListener(EventListener listener) {
        if (listener == null) {
            return 0;
        }
        int removed = 0;
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Listener storedListener = iterator.next().getListener();
                if (storedListener == null) {
                    iterator.remove();
                    continue;
                }
                if (!listener.equals(storedListener)) continue;
                iterator.remove();
                ++removed;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeListener(EventListener listener) {
        if (listener == null) {
            return 0;
        }
        int removed = 0;
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Listener storedListener = iterator.next().getListener();
                if (storedListener == null) {
                    iterator.remove();
                    continue;
                }
                if (listener != storedListener) continue;
                iterator.remove();
                ++removed;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(ListenerNotifier<Listener> notifier) {
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Listener storedListener = iterator.next().getListener();
                if (storedListener == null) {
                    iterator.remove();
                    continue;
                }
                notifier.notify(storedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqualListening(EventListener listener) {
        if (listener == null) {
            return false;
        }
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Listener storedListener = iterator.next().getListener();
                if (storedListener == null) {
                    iterator.remove();
                    continue;
                }
                if (!listener.equals(storedListener)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening(EventListener listener) {
        if (listener == null) {
            return false;
        }
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Listener storedListener = iterator.next().getListener();
                if (storedListener == null) {
                    iterator.remove();
                    continue;
                }
                if (listener != storedListener) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ListenerRemover remover) {
        ConcurrentLinkedQueue<ListenerStore<Listener>> concurrentLinkedQueue = this.listeners;
        synchronized (concurrentLinkedQueue) {
            Iterator<ListenerStore<Listener>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Listener storedListener = iterator.next().getListener();
                if (storedListener == null) {
                    iterator.remove();
                    continue;
                }
                if (!remover.remove((EventListener)storedListener)) continue;
                iterator.remove();
            }
        }
    }

    private static class WeakListenerStore<Listener extends EventListener>
    extends ListenerStore<Listener> {
        private WeakReference<Listener> listenerReference = null;

        public WeakListenerStore(Listener listener) {
            this.listenerReference = new WeakReference<Listener>(listener);
        }

        @Override
        public Listener getListener() {
            return (Listener)((EventListener)this.listenerReference.get());
        }
    }

    private static class StrongListenerStore<Listener extends EventListener>
    extends ListenerStore<Listener> {
        private Listener listener;

        public StrongListenerStore(Listener listener) {
            this.listener = listener;
        }

        @Override
        public Listener getListener() {
            return this.listener;
        }
    }

    private static abstract class ListenerStore<Listener extends EventListener> {
        private ListenerStore() {
        }

        public abstract Listener getListener();
    }

    public static interface ListenerRemover {
        public boolean remove(EventListener var1);
    }

    public static interface ListenerNotifier<Listener extends EventListener> {
        public void notify(Listener var1);
    }
}

