/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.future;

import cz.cuni.amis.utils.TimeUnitToMillis;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CombinedBooleanFuture
implements Future<Boolean> {
    private Future<Boolean>[] futures;

    public CombinedBooleanFuture(Future<Boolean>[] futures) {
        this.futures = futures;
        if (this.futures == null) {
            throw new IllegalArgumentException("'futures' can't be null");
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean canceled = true;
        for (Future<Boolean> future : this.futures) {
            canceled = canceled && future.cancel(mayInterruptIfRunning);
        }
        return canceled;
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        boolean result = true;
        for (Future<Boolean> future : this.futures) {
            Boolean futureResult = future.get();
            result = result && futureResult != null && futureResult != false;
        }
        return result;
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = TimeUnitToMillis.toMillis(timeout, unit);
        long start = System.currentTimeMillis();
        boolean result = true;
        for (Future<Boolean> future : this.futures) {
            long futureStart = System.currentTimeMillis();
            if (futureStart - start > timeoutMillis) {
                throw new TimeoutException("timeouted after " + timeout + " " + (Object)((Object)unit));
            }
            Boolean futureResult = future.get(timeoutMillis - (futureStart - start), TimeUnit.MILLISECONDS);
            result = result && futureResult != null && futureResult != false;
        }
        return result;
    }

    public Boolean[] getAll(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = TimeUnitToMillis.toMillis(timeout, unit);
        long start = System.currentTimeMillis();
        Boolean[] results = new Boolean[this.futures.length];
        int i = 0;
        for (Future<Boolean> future : this.futures) {
            long futureStart = System.currentTimeMillis();
            if (futureStart - start > timeoutMillis) {
                throw new TimeoutException("timeouted after " + timeout + " " + (Object)((Object)unit));
            }
            results[i++] = future.get(timeoutMillis - (futureStart - start), TimeUnit.MILLISECONDS);
        }
        return results;
    }

    @Override
    public boolean isCancelled() {
        boolean result = false;
        for (Future<Boolean> future : this.futures) {
            Boolean futureResult = future.isCancelled();
            result = result || futureResult != null && futureResult != false;
        }
        return result;
    }

    @Override
    public boolean isDone() {
        boolean result = true;
        for (Future<Boolean> future : this.futures) {
            result = result && future.isDone();
        }
        return result;
    }

    public Future<Boolean>[] getFutures() {
        return this.futures;
    }
}

