/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.objects;

import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocomotive;
import java.io.Serializable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Velocity
implements ILocomotive,
Serializable {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean isPlanarZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public double size() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double sizeSquare() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Velocity normalize() {
        double d = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Velocity(this.x * d, this.y * d, this.z * d);
    }

    public Velocity negate() {
        return new Velocity(-this.x, -this.y, -this.z);
    }

    public Velocity absolute() {
        return new Velocity(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public Velocity scale(double d) {
        return new Velocity(this.x * d, this.y * d, this.z * d);
    }

    public double dot(Velocity v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public static double dot(Velocity v1, Velocity v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public Velocity cross(Velocity v) {
        return new Velocity(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public static Velocity cross(Velocity v1, Velocity v2) {
        return new Velocity(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
    }

    public Velocity add(Velocity v) {
        return new Velocity(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public static Velocity add(Velocity v1, Velocity v2) {
        return new Velocity(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
    }

    public Velocity sub(Velocity v) {
        return new Velocity(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public static Velocity sub(Velocity v1, Velocity v2) {
        return new Velocity(v1.x - v2.x, v1.y - v2.y, v1.z - v2.z);
    }

    public Velocity interpolate(Velocity v, double d) {
        double d1 = 1.0 - d;
        return new Velocity(d1 * this.x + d * v.x, d1 * this.y + d * v.y, d1 * this.z + d * v.z);
    }

    public static Velocity interpolate(Velocity v1, Velocity v2, double d) {
        double d1 = 1.0 - d;
        return new Velocity(d1 * v1.x + d * v2.x, d1 * v1.y + d * v2.y, d1 * v1.z + d * v2.z);
    }

    public boolean equals(Velocity v) {
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public static boolean equal(Velocity v1, Velocity v2) {
        return v1.x == v2.x && v1.y == v2.y && v1.z == v2.z;
    }

    public boolean equals(Velocity v, double epsilon) {
        double d = this.x - v.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d2 > epsilon) {
            return false;
        }
        d = this.y - v.y;
        double d3 = d >= 0.0 ? d : -d;
        if (d3 > epsilon) {
            return false;
        }
        d = this.z - v.z;
        double d4 = d >= 0.0 ? d : -d;
        return !(d4 > epsilon);
    }

    public static boolean equal(Velocity v1, Velocity v2, double epsilon) {
        double d = v1.x - v2.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d2 > epsilon) {
            return false;
        }
        d = v1.y - v2.y;
        double d3 = d >= 0.0 ? d : -d;
        if (d3 > epsilon) {
            return false;
        }
        d = v1.z - v2.z;
        double d4 = d >= 0.0 ? d : -d;
        return !(d4 > epsilon);
    }

    public Velocity align() {
        return new Velocity(this.x, this.y, 0.0);
    }

    public Velocity sideways() {
        return new Velocity(this.y, -this.x, 0.0);
    }

    @Override
    public Velocity getVelocity() {
        return this;
    }

    public Vector3d getVector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Velocity() {
    }

    public Velocity(Velocity velocity) {
        this.x = velocity.getX();
        this.y = velocity.getY();
        this.z = velocity.getZ();
    }

    public Velocity(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Velocity(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Velocity(double[] d) {
        this.x = d[0];
        this.y = d[1];
        this.z = d[2];
    }

    public Velocity(Tuple3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public String toString() {
        return String.format("[%.2f, %.2f, %.2f]", this.x, this.y, this.z);
    }
}

