/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.objects;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Velocity;
import java.io.Serializable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class Location
implements ILocated,
Serializable {
    @JProp
    public double x = 0.0;
    @JProp
    public double y = 0.0;
    @JProp
    public double z = 0.0;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Location add(Location l) {
        return new Location(this.x + l.x, this.y + l.y, this.z + l.z);
    }

    public static Location add(Location l1, Location l2) {
        return new Location(l1.x + l2.x, l1.y + l2.y, l1.z + l2.z);
    }

    public Location sub(Location l) {
        return new Location(this.x - l.x, this.y - l.y, this.z - l.z);
    }

    public static Location sub(Location l1, Location l2) {
        return new Location(l1.x - l2.x, l1.y - l2.y, l1.z - l2.z);
    }

    public Location add(Velocity v) {
        return new Location(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public static Location add(Location l, Velocity v) {
        return new Location(l.x + v.x, l.y + v.y, l.z + v.z);
    }

    public Location sub(Velocity v) {
        return new Location(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public static Location sub(Location l, Velocity v) {
        return new Location(l.x - v.x, l.y - v.y, l.z - v.z);
    }

    public Location scale(double d) {
        return new Location(this.x * d, this.y * d, this.z * d);
    }

    public Location interpolate(Location l, double d) {
        double d1 = 1.0 - d;
        return new Location(d1 * this.x + d * l.x, d1 * this.y + d * l.y, d1 * this.z + d * l.z);
    }

    public static Location interpolate(Location l1, Location l2, double d) {
        double d1 = 1.0 - d;
        return new Location(d1 * l1.x + d * l2.x, d1 * l1.y + d * l2.y, d1 * l1.z + d * l2.z);
    }

    public boolean equals(Location v) {
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public static boolean equal(Location l1, Location l2) {
        return l1.x == l2.x && l1.y == l2.y && l1.z == l2.z;
    }

    public boolean equals(Location l, double epsilon) {
        double d = this.x - l.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d2 > epsilon) {
            return false;
        }
        d = this.y - l.y;
        double d3 = d >= 0.0 ? d : -d;
        if (d3 > epsilon) {
            return false;
        }
        d = this.z - l.z;
        double d4 = d >= 0.0 ? d : -d;
        return !(d4 > epsilon);
    }

    public static boolean equal(Location l1, Location l2, double epsilon) {
        double d = l1.x - l2.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d2 > epsilon) {
            return false;
        }
        d = l1.y - l2.y;
        double d3 = d >= 0.0 ? d : -d;
        if (d3 > epsilon) {
            return false;
        }
        d = l1.z - l2.z;
        double d4 = d >= 0.0 ? d : -d;
        return !(d4 > epsilon);
    }

    public double getDistance(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        double dz = l.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getDistance(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        double dz = l2.z - l1.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double getDistanceSquare(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        double dz = l.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSquare(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        double dz = l2.z - l1.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double getDistanceL1(Location l) {
        double dx = Math.abs(l.x - this.x);
        double dy = Math.abs(l.y - this.y);
        double dz = Math.abs(l.z - this.z);
        return dx + dy + dz;
    }

    public static double getDistanceL1(Location l1, Location l2) {
        double dx = Math.abs(l2.x - l1.x);
        double dy = Math.abs(l2.y - l1.y);
        double dz = Math.abs(l2.z - l1.z);
        return dx + dy + dz;
    }

    public double getDistanceLinf(Location l) {
        double dx = Math.abs(l.x - this.x);
        double dy = Math.abs(l.y - this.y);
        double dz = Math.abs(l.z - this.z);
        return Math.max(Math.max(dx, dy), dz);
    }

    public static double getDistanceLinf(Location l1, Location l2) {
        double dx = Math.abs(l2.x - l1.x);
        double dy = Math.abs(l2.y - l1.y);
        double dz = Math.abs(l2.z - l1.z);
        return Math.max(Math.max(dx, dy), dz);
    }

    public double getDistancePlane(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double getDistancePlane(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public Location getLocation() {
        return this;
    }

    public Point3d getPoint3d() {
        return new Point3d(this.x, this.y, this.z);
    }

    public Location() {
    }

    public Location(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Location(Location source) {
        this.x = source.getX();
        this.y = source.getY();
        this.z = source.getZ();
    }

    public Location(double[] d) {
        this.x = d[0];
        this.y = d[1];
        this.z = d[2];
    }

    public Location(Tuple3d p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public double dot(Location b) {
        return this.x * b.getX() + this.y * b.getY() + this.z * b.getZ();
    }

    public Location cross(Location b) {
        return new Location(this.y * b.getZ() - this.z * b.getY(), this.z * b.getX() - this.x * b.getZ(), this.x * b.getY() - this.y * b.getX());
    }

    public Rotation getRotation(Rotation.Order order) {
        Location this_normalized = this.getNormalized();
        double yaw = 0.0;
        double pitch = 0.0;
        switch (order) {
            case YAW_PITCH_ROLL: 
            case ROLL_YAW_PITCH: 
            case YAW_ROLL_PITCH: {
                yaw = Math.atan2(this_normalized.getY(), Math.sqrt(1.0 - this_normalized.getY() * this_normalized.getY()));
                pitch = Math.atan2(this_normalized.getZ(), this_normalized.getX());
                break;
            }
            case PITCH_YAW_ROLL: 
            case PITCH_ROLL_YAW: 
            case ROLL_PITCH_YAW: {
                pitch = Math.atan2(Math.sqrt(1.0 - this_normalized.getZ() * this_normalized.getZ()), this_normalized.getZ());
                yaw = Math.atan2(this_normalized.getX(), this_normalized.getY());
            }
        }
        return new Rotation(pitch / Math.PI * 32768.0 - 1.0, yaw / Math.PI * 32768.0 - 1.0, 0.0);
    }

    public Rotation getQuatLikeRotationSeq(Rotation.Order order) {
        Location projected = new Location(1.0, 0.0, 0.0);
        double yaw = 0.0;
        double pitch = 0.0;
        switch (order) {
            case ROLL_YAW_PITCH: {
                yaw = Math.atan2(this.getY(), this.getX());
                projected = projected.mul(Rotation.constructXYRot(yaw));
                pitch = Math.atan2(this.getZ(), new Location(this.getX(), this.getY(), 0.0).dot(projected));
                return new Rotation(pitch / Math.PI * 32768.0 - 1.0, yaw / Math.PI * 32768.0 - 1.0, 0.0);
            }
        }
        return new Rotation();
    }

    public Location getNormalized() {
        return this.scale(1.0 / this.getLength());
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Location mul(Matrix3d matrix) {
        Location res = new Location();
        res.x = matrix.getM00() * this.x + matrix.getM10() * this.y + matrix.getM20() * this.z;
        res.y = matrix.getM01() * this.x + matrix.getM11() * this.y + matrix.getM21() * this.z;
        res.z = matrix.getM02() * this.x + matrix.getM12() * this.y + matrix.getM22() * this.z;
        return res;
    }

    public Location invert() {
        return new Location(-this.x, -this.y, -this.z);
    }

    public String toString() {
        return String.format("[%.2f, %.2f, %.2f]", this.x, this.y, this.z);
    }
}

