/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.marks;

import java.io.Serializable;
import java.util.Calendar;

public class LogMarkDuration
implements Serializable {
    private final String message;
    private final long created;
    private final long duration;
    private Type type;

    private LogMarkDuration(String msg, long created, long duration, Type type) {
        this.message = msg;
        this.created = created;
        this.duration = duration;
        this.type = type;
    }

    protected LogMarkDuration(String msg, long duration, Type type) {
        this(msg, Calendar.getInstance().getTimeInMillis(), duration, type);
    }

    public static LogMarkDuration createSingleLengthEvent(String msg) {
        return new LogMarkDuration(msg, 0L, Type.SINGLE_EVENT);
    }

    public static LogMarkDuration createFixedLengthEvent(String msg, long duration) {
        return new LogMarkDuration(msg, duration, Type.FIXED_DURATION);
    }

    public static LogMarkDuration createVariableLengthEvent(String msg) {
        return new LogMarkDuration(msg, Integer.MAX_VALUE, Type.START_EVENT);
    }

    public String toString() {
        return "LogMarkDuration " + this.getMessage();
    }

    public String getMessage() {
        return this.message;
    }

    public long getCreated() {
        return this.created;
    }

    public Type getType() {
        return this.type;
    }

    public long getDuration() {
        return this.duration;
    }

    public LogMarkDuration getEndMark() {
        if (this.getType() == Type.START_EVENT || this.getType() == Type.END_EVENT) {
            return new LogMarkDuration(this.message, this.created, this.duration, Type.END_EVENT);
        }
        throw new IllegalStateException("Mark is not in a state that can be changed to END_EVENT, it is in " + (Object)((Object)this.getType()));
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof LogMarkDuration)) {
            return false;
        }
        LogMarkDuration second = (LogMarkDuration)aThat;
        return this.equalWithoutType(second) && this.getType() == second.getType();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.message != null ? this.message.hashCode() : 0);
        hash = 97 * hash + (int)(this.created ^ this.created >>> 32);
        hash = 97 * hash + (int)(this.duration ^ this.duration >>> 32);
        return hash;
    }

    public boolean equalWithoutType(LogMarkDuration second) {
        LogMarkDuration first = this;
        boolean msgEqual = first.getMessage() == null ? second.getMessage() == null : first.getMessage().equals(second.getMessage());
        boolean createdEqual = first.getCreated() == second.getCreated();
        boolean durEqual = first.getDuration() == second.getDuration();
        return msgEqual && createdEqual && durEqual;
    }

    public static enum Type {
        SINGLE_EVENT,
        FIXED_DURATION,
        START_EVENT,
        END_EVENT;

    }
}

