/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.jmx;

import cz.cuni.amis.pogamut.base.agent.jmx.AgentJMX;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogCategoriesMBean;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogPublisher;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class JMXLogCategories
implements ILogCategories,
JMXLogCategoriesMBean {
    public static final String JMX_NAME = "logCategories";
    protected ILogCategories logCategories;
    protected MBeanServer mBeanServer;
    protected ObjectName objectName = null;

    public static String getJMXLogCategoriesName(String jmxDomain, String path) {
        if (!path.isEmpty()) {
            return jmxDomain + ":type=" + path + ".logging,name=" + JMX_NAME;
        }
        return jmxDomain + ":type=logging,name=" + JMX_NAME;
    }

    public JMXLogCategories(ILogCategories logCategories, MBeanServer mBeanServer, ObjectName parent) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, NullPointerException {
        this.logCategories = logCategories;
        this.mBeanServer = mBeanServer;
        this.objectName = ObjectName.getInstance(JMXLogCategories.getObjectName(parent));
        mBeanServer.registerMBean(this, this.objectName);
        for (LogCategory category : this.getCategories().values()) {
            category.newHandler(this.newJMXLogPublisher(category.getName()));
        }
    }

    @Override
    public synchronized LogCategory getCategory(String name) {
        if (this.hasCategory(name)) {
            return this.logCategories.getCategory(name);
        }
        LogCategory newCategory = this.logCategories.getCategory(name);
        newCategory.newHandler(this.newJMXLogPublisher(name));
        return newCategory;
    }

    private JMXLogPublisher newJMXLogPublisher(String name) {
        try {
            ObjectName categoryObjName = ObjectName.getInstance(JMXLogCategories.getJMXCategoryName(this.objectName, name));
            JMXLogPublisher logPublisher = new JMXLogPublisher(categoryObjName, name);
            this.mBeanServer.registerMBean(logPublisher, categoryObjName);
            return logPublisher;
        }
        catch (Exception e) {
            System.out.println("Can't register JMXLogPublisher with name " + JMXLogCategories.getJMXCategoryName(this.objectName, name) + " stack trace follows...");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ObjectName getJMXCategoryName(String categoryName) {
        return JMXLogCategories.getJMXCategoryName(this.objectName, categoryName);
    }

    public static ObjectName getJMXCategoryName(ObjectName parent, String categoryName) {
        try {
            return AgentJMX.getObjectName(parent, categoryName, null);
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Map<String, LogCategory> getCategories() {
        return this.logCategories.getCategories();
    }

    @Override
    public String[] getCategoryNames() {
        return this.logCategories.getCategoryNames();
    }

    @Override
    public String[] getCategoryNamesSorted() {
        return this.logCategories.getCategoryNamesSorted();
    }

    @Override
    public boolean hasCategory(String name) {
        return this.logCategories.hasCategory(name);
    }

    @Override
    public void setLevel(Level newLevel) {
        this.logCategories.setLevel(newLevel);
    }

    public static ObjectName getObjectName(ObjectName parent) throws MalformedObjectNameException {
        return AgentJMX.getObjectName(parent, JMX_NAME, "logging");
    }
}

