/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private SimpleDateFormat yearDateFormat = new SimpleDateFormat("y");
    private SimpleDateFormat monthDateFormat = new SimpleDateFormat("M");
    private SimpleDateFormat dayDateFormat = new SimpleDateFormat("d");
    private SimpleDateFormat hourDateFormat = new SimpleDateFormat("H");
    private SimpleDateFormat minuteDateFormat = new SimpleDateFormat("m");
    private SimpleDateFormat secondDateFormat = new SimpleDateFormat("s");
    private SimpleDateFormat msecondDateFormat = new SimpleDateFormat("S");
    private StringBuffer buffer = new StringBuffer(512);
    private boolean lineEnds;
    public static final String[] whitespaces = new String[]{"        ", "       ", "      ", "     ", "    ", "   ", "  ", " ", ""};

    public LogFormatter() {
        this.lineEnds = false;
    }

    public LogFormatter(boolean lineEnds) {
        this.lineEnds = lineEnds;
    }

    @Override
    public String format(LogRecord record) {
        this.buffer.delete(0, this.buffer.length());
        this.buffer.append(" [");
        this.buffer.append(record.getLevel().toString());
        this.buffer.append("]");
        this.buffer.append(whitespaces[record.getLevel().toString().length()]);
        Date date = new Date(record.getMillis());
        this.buffer.append(this.yearDateFormat.format(date));
        this.buffer.append("-");
        String month = this.monthDateFormat.format(date);
        if (month.length() > 1) {
            this.buffer.append(month);
        } else {
            this.buffer.append("0");
            this.buffer.append(month);
        }
        this.buffer.append("-");
        String day = this.dayDateFormat.format(date);
        if (day.length() > 1) {
            this.buffer.append(day);
        } else {
            this.buffer.append("0");
            this.buffer.append(day);
        }
        this.buffer.append(" ");
        String hour = this.hourDateFormat.format(date);
        if (hour.length() > 1) {
            this.buffer.append(hour);
        } else {
            this.buffer.append("0");
            this.buffer.append(hour);
        }
        this.buffer.append(":");
        String minute = this.minuteDateFormat.format(date);
        if (minute.length() > 1) {
            this.buffer.append(minute);
        } else {
            this.buffer.append("0");
            this.buffer.append(minute);
        }
        this.buffer.append(":");
        String second = this.secondDateFormat.format(date);
        if (second.length() > 1) {
            this.buffer.append(second);
        } else {
            this.buffer.append("0");
            this.buffer.append(second);
        }
        this.buffer.append(".");
        String msecond = this.msecondDateFormat.format(date);
        if (msecond.length() > 2) {
            this.buffer.append(msecond);
        } else if (msecond.length() > 1) {
            this.buffer.append("0");
            this.buffer.append(msecond);
        } else {
            this.buffer.append("00");
            this.buffer.append(msecond);
        }
        this.buffer.append(" ");
        this.buffer.append("<");
        this.buffer.append(record.getLoggerName());
        this.buffer.append("> ");
        this.buffer.append(record.getMessage());
        if (this.lineEnds) {
            this.buffer.append("\r\n");
        }
        return this.buffer.toString();
    }
}

