/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AbstractAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogCategories;
import cz.cuni.amis.utils.ExceptionToString;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@AgentScoped
public class DefaultAgentLogger
extends AbstractAgentLogger {
    protected ILogCategories categories;
    protected LogCategory in;
    protected LogCategory out;
    protected LogCategory platform;
    protected LogCategory user;

    public DefaultAgentLogger() {
        this.categories = new LogCategories();
        this.initDefaultLoggingCategories();
    }

    public DefaultAgentLogger(LogCategories logCategories) {
        this.categories = logCategories;
        this.initDefaultLoggingCategories();
    }

    @Override
    public LogCategory in() {
        return this.in;
    }

    @Override
    public LogCategory out() {
        return this.out;
    }

    @Override
    public LogCategory user() {
        return this.user;
    }

    @Override
    public LogCategory platform() {
        return this.platform;
    }

    private void initDefaultLoggingCategories() {
        this.in = this.categories.getCategory(AbstractAgentLogger.CategoryNames.IN.getName());
        this.out = this.categories.getCategory(AbstractAgentLogger.CategoryNames.OUT.getName());
        this.user = this.categories.getCategory(AbstractAgentLogger.CategoryNames.USER.getName());
        this.platform = this.categories.getCategory(AbstractAgentLogger.CategoryNames.PLATFORM.getName());
    }

    @Override
    public void enableJMX(MBeanServer mBeanServer, ObjectName parent) throws JMXAlreadyEnabledException, CantStartJMXException {
        if (this.categories instanceof JMXLogCategories) {
            throw new JMXAlreadyEnabledException("AgentLogger has already JMX turned on.", this.platform(), (Object)this);
        }
        try {
            JMXLogCategories newCategories = new JMXLogCategories(this.categories, mBeanServer, parent);
            this.categories = newCategories;
        }
        catch (Exception e) {
            throw new CantStartJMXException(ExceptionToString.process("Can't start JMX for agent logger", e), this.platform(), (Object)this);
        }
    }

    @Override
    public ILogCategories getCategories() {
        return this.categories;
    }
}

