/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import java.util.logging.Handler;
import java.util.logging.Level;

@AgentScoped
public abstract class AbstractAgentLogger
implements AgentLogger {
    @Override
    public LogCategory getCategory(String name) {
        return this.getCategories().getCategory(name);
    }

    @Override
    public abstract ILogCategories getCategories();

    @Override
    public abstract LogCategory in();

    @Override
    public abstract LogCategory out();

    @Override
    public abstract LogCategory user();

    @Override
    public abstract LogCategory platform();

    @Override
    public void addConsoleHandlersToAllCategories() {
        this.addPublisherToAllCategories(new LogPublisher.ConsolePublisher());
    }

    @Override
    public void addPublisherToAllCategories(ILogPublisher logPublisher) {
        this.addHandlerToAllCategories(new LogHandler(logPublisher));
    }

    @Override
    public void addHandlerToAllCategories(Handler handler) {
        for (LogCategory category : this.getCategories().getCategories().values()) {
            category.addHandler(handler);
        }
    }

    @Override
    public void setLevel(Level newLevel) {
        this.getCategories().setLevel(newLevel);
    }

    public static enum CategoryNames {
        IN("In"),
        OUT("Out"),
        USER("User"),
        PLATFORM("Platform");

        private String name;

        private CategoryNames(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

