/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.WorldObjectFirstEncounteredEvent;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class WorldObjectFuture<T extends IWorldObject>
implements Future<T> {
    IWorldView worldView = null;
    T worldObject = null;
    CountDownLatch latch = new CountDownLatch(1);
    IWorldObjectListener<T, WorldObjectFirstEncounteredEvent<T>> listener = null;

    public WorldObjectFuture(final IWorldView worldView, final String id, final Class<T> objectClass) {
        this.listener = new IWorldObjectListener<T, WorldObjectFirstEncounteredEvent<T>>(){

            @Override
            public void notify(WorldObjectFirstEncounteredEvent<T> event) {
                if (event.getObject().getId().getStringId().equals(id)) {
                    WorldObjectFuture.this.worldObject = event.getObject();
                    worldView.removeObjectListener(objectClass, WorldObjectFirstEncounteredEvent.class, this);
                    WorldObjectFuture.this.customObjectEncounteredHook(WorldObjectFuture.this.worldObject);
                    WorldObjectFuture.this.latch.countDown();
                }
            }
        };
        worldView.addObjectListener(objectClass, WorldObjectFirstEncounteredEvent.class, this.listener);
    }

    protected void customObjectEncounteredHook(T obj) {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isDone() {
        return this.worldObject != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.worldObject;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

