/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.IAgentRunner;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutPlatform;
import java.util.logging.Level;

public class BotRunner<T extends IAgent>
implements IAgentRunner<T> {
    IAgentFactory factory;
    int port = -1;
    String host = null;

    public BotRunner(IAgentFactory factory) {
        this.factory = factory;
        this.init();
    }

    public BotRunner(IAgentFactory factory, String host, int port) {
        this.factory = factory;
        this.host = host;
        this.port = port;
    }

    protected void init() {
        PogamutPlatform pl = Pogamut.getPlatform();
        this.host = pl.getProperty("pogamut.bot.host");
        this.port = pl.getIntProperty("pogamut.bot.port");
    }

    @Override
    public T startAgent() throws PogamutException {
        IAgent agent = null;
        agent = this.factory.newAgent(new SocketConnectionAddress(this.host, this.port));
        agent.getLogger().addConsoleHandlersToAllCategories();
        agent.getLogger().setLevel(Level.INFO);
        this.preStartHook(agent);
        agent.start();
        return (T)agent;
    }

    protected void preStartHook(T agent) throws PogamutException {
    }
}

