/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.factory.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnection;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.PogamutAgentModule;

public class GuiceAgentFactory<ADDRESS extends IWorldConnectionAddress>
implements IAgentFactory<ADDRESS> {
    private Injector injector = null;
    private PogamutAgentModule agentModule = null;

    public GuiceAgentFactory(PogamutAgentModule agentModule) {
        this.agentModule = agentModule;
        if (this.agentModule == null) {
            throw new IllegalArgumentException("'agentModule' can't be null");
        }
    }

    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])new Module[]{this.agentModule});
        }
        return this.injector;
    }

    protected PogamutAgentModule getAgentModule() {
        return this.agentModule;
    }

    @Override
    public synchronized IAgent newAgent(ADDRESS address) throws PogamutException {
        this.getAgentModule().getAgentScope().clearScope();
        IAgent agent = (IAgent)this.getInjector().getInstance(IAgent.class);
        IWorldConnection connection = (IWorldConnection)this.getInjector().getInstance(IWorldConnection.class);
        connection.connect(address);
        return agent;
    }
}

