/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.exceptions;

import cz.cuni.amis.utils.ExceptionToString;
import java.util.logging.Logger;

public class PogamutRuntimeException
extends RuntimeException {
    private boolean hasBeenLogged = false;
    private Object origin;

    public PogamutRuntimeException(String message, Object origin) {
        super(origin.toString() + ": " + message);
        this.origin = origin;
    }

    public PogamutRuntimeException(String message, Throwable cause, Object origin) {
        super(origin.toString() + ": " + message + " (caused by: " + cause.getMessage() + ")", cause);
        this.origin = origin;
    }

    public PogamutRuntimeException(String message, Logger log, Object origin) {
        super(origin.toString() + ": " + message);
        this.origin = origin;
        this.logException(log);
    }

    public PogamutRuntimeException(String message, Throwable cause, Logger log, Object origin) {
        super(origin.toString() + ": " + message + " (caused by: " + cause.getMessage() + ")", cause);
        this.origin = origin;
        this.logException(log);
    }

    public boolean isLogged() {
        return this.hasBeenLogged;
    }

    public void setLogged(boolean logged) {
        this.hasBeenLogged = logged;
    }

    public Object getOrigin() {
        return this.origin;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getMessage() + "]";
    }

    public synchronized void logException(Logger log) {
        try {
            log.severe(ExceptionToString.process(this.getMessage(), this));
            this.hasBeenLogged = true;
        }
        catch (Exception e) {
            System.err.println("PogamutRuntimeException (and can't log to log '" + log.getName() + "' because \"" + e.getMessage() + "\"), exception: " + this.toString());
            this.printStackTrace(System.err);
        }
    }

    public synchronized void logExceptionOnce(Logger log) {
        if (this.isLogged()) {
            return;
        }
        this.logException(log);
    }
}

