/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.BatchAwareWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;

public abstract class SyncLockableBatchAwareWorldView
extends BatchAwareWorldView
implements ILockableWorldView {
    private Queue<List<IWorldChangeEvent>> batches = new LinkedList<List<IWorldChangeEvent>>();
    private List<IWorldChangeEvent> currentBatch = new ArrayList<IWorldChangeEvent>();
    private boolean locked = false;
    private boolean inLock = false;
    private boolean beginCame = false;
    private final Object objectMutex = new Object();
    private CountDownLatch lockLatch = new CountDownLatch(1);
    private boolean stopRequested = false;

    @Inject
    public SyncLockableBatchAwareWorldView(IMediator messageSource, AgentLogger log) {
        super(messageSource, log);
    }

    protected abstract boolean isBatchBeginEvent(IWorldChangeEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() throws InterruptedException {
        Object object = this.objectMutex;
        synchronized (object) {
            if (this.isLocked()) {
                return;
            }
            this.locked = true;
            this.log.finer("World view locked.");
        }
        this.lockLatch.await();
        if (this.stopRequested) {
            throw new InterruptedException("lock() interrupted with the request to stop the work");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.isLocked()) {
                return;
            }
            this.log.finer("World view is being unlocked.");
            this.locked = false;
            this.inLock = false;
            this.processBatches();
            this.log.finer("World view unlocked.");
            this.lockLatch = new CountDownLatch(1);
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public boolean isInLock() {
        return this.inLock;
    }

    private void processBatches() {
        for (List list : this.batches) {
            this.processBatch(list);
        }
        this.batches.clear();
        this.processBatch(this.currentBatch);
    }

    private void processBatch(List<IWorldChangeEvent> batch) {
        for (IWorldChangeEvent event : batch) {
            super.notify(event);
        }
        batch.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(IWorldChangeEvent event) {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.beginCame) {
                if (this.isBatchBeginEvent(event)) {
                    this.beginCame = true;
                } else {
                    super.notify(event);
                    return;
                }
            }
            if (this.isLocked()) {
                if (this.isInLock()) {
                    if (this.isBatchEndEvent(event)) {
                        this.currentBatch.add(event);
                        this.batches.add(this.currentBatch);
                        this.currentBatch = new ArrayList<IWorldChangeEvent>(this.currentBatch.size() + 10);
                    } else {
                        this.currentBatch.add(event);
                    }
                } else if (this.isBatchEndEvent(event)) {
                    super.notify(event);
                    this.log.finer("World view in-locked state, raising the lock() latch.");
                    this.lockLatch.countDown();
                    this.inLock = true;
                } else {
                    super.notify(event);
                }
            } else {
                super.notify(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        Object object = this.objectMutex;
        synchronized (object) {
            this.stopRequested = true;
            this.lockLatch.countDown();
        }
    }
}

