/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldEventWrapper;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.utils.reason.IReasonRunningChanged;
import cz.cuni.amis.pogamut.base.communication.utils.reason.ReasonKilled;
import cz.cuni.amis.pogamut.base.communication.utils.reason.ReasonStarted;
import cz.cuni.amis.pogamut.base.communication.utils.reason.ReasonStopped;
import cz.cuni.amis.pogamut.base.communication.worldview.AbstractWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.ReasonFlag;
import java.util.LinkedList;
import java.util.Queue;

@AgentScoped
public class EventDrivenWorldView
extends AbstractWorldView
implements IStartableWorldView {
    private ReasonFlag<Boolean, IReasonRunningChanged> running = new ReasonFlag(false);
    protected boolean receiveEventProcessing = false;
    protected Queue<IWorldChangeEvent> notifyEventsList = new LinkedList<IWorldChangeEvent>();
    protected IMediator messageSource = null;

    @Inject
    public EventDrivenWorldView(IMediator messageSource, AgentLogger log) {
        super(log);
        this.messageSource = messageSource;
        messageSource.setMediatorOutput(this);
    }

    @Override
    protected void raiseEvent(IWorldEvent event) {
        try {
            super.raiseEvent(event);
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process("exception happend during raising event " + event, e));
            this.stop();
        }
    }

    protected void innerNotify(IWorldChangeEvent event) {
        this.log.info("WV: processing " + event);
        NullCheck.check(event, "event");
        if (event instanceof IWorldObjectUpdatedEvent) {
            IWorldObjectUpdatedEvent updateEvent = (IWorldObjectUpdatedEvent)event;
            IWorldObject obj = this.get(updateEvent.getId());
            if (obj == null) {
                obj = updateEvent.update(null);
                this.addWorldObject(obj);
                this.raiseEvent(new WorldObjectFirstEncounteredEvent<IWorldObject>(obj));
                this.objectUpdated(obj);
            } else {
                IWorldObject updatedObject = updateEvent.update(obj);
                if (updatedObject == null) {
                    this.removeWorldObject(obj);
                    this.raiseEvent(new WorldObjectDestroyedEvent<IWorldObject>(obj));
                } else {
                    if (updatedObject != obj) {
                        throw new RuntimeException("Update event (class: " + event.getClass() + ") returned different world object, wrong behavior.");
                    }
                    this.objectUpdated(updatedObject);
                }
            }
        } else if (event instanceof IWorldEventWrapper) {
            this.raiseEvent(((IWorldEventWrapper)event).getWorldEvent());
        } else if (event instanceof IWorldEvent) {
            this.raiseEvent((IWorldEvent)((Object)event));
        } else {
            throw new RuntimeException("Unsupported event type received (" + event.getClass() + ").");
        }
    }

    protected void objectUpdated(IWorldObject obj) {
        this.raiseEvent(new WorldObjectUpdatedEvent<IWorldObject>(obj));
    }

    @Override
    public synchronized void notify(IWorldChangeEvent event) {
        if (!((Boolean)this.running.getFlag()).booleanValue()) {
            this.log.severe(this + ": not running but received message");
            this.stop();
            return;
        }
        if (this.receiveEventProcessing) {
            this.notifyEventsList.add(event);
            return;
        }
        this.receiveEventProcessing = true;
        this.innerNotify(event);
        while (this.notifyEventsList.size() != 0) {
            this.innerNotify(this.notifyEventsList.poll());
        }
        this.receiveEventProcessing = false;
    }

    @Override
    public void start() throws PogamutException {
        if (((Boolean)this.running.getFlag()).booleanValue()) {
            return;
        }
        this.messageSource.start();
        this.running.setFlag(true, new ReasonStarted());
    }

    @Override
    public void stop() {
        if (!((Boolean)this.running.getFlag()).booleanValue()) {
            return;
        }
        this.running.setFlag(false, new ReasonStopped());
        this.messageSource.stop();
    }

    @Override
    public void kill() {
        this.running.setFlag(false, new ReasonKilled());
        this.messageSource.kill();
    }

    @Override
    public ReasonFlag<Boolean, IReasonRunningChanged> getRunning() {
        return this.running;
    }
}

