/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.IWorldObjectId;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.LazyMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@AgentScoped
public abstract class AbstractWorldView
implements IWorldView {
    private ListenerNotifier notifier = new ListenerNotifier();
    private HashMapMap<Class, IWorldObjectId, IWorldObject> worldObjects = new HashMapMap();
    private Map<Class, Map<IWorldObjectId, IWorldObject>> syncWorldObjects = Collections.synchronizedMap(this.worldObjects);
    private Map<IWorldObjectId, IWorldObject> knownObjects = Collections.synchronizedMap(new HashMap());
    private ListenersMap<Class> eventListeners = new ListenersMap();
    private ListenersMap<Class> objectsListeners = new ListenersMap();
    private Map<Class, ListenersMap<Class>> objectEventListeners = Collections.synchronizedMap(new LazyMap<Class, ListenersMap<Class>>(){

        @Override
        protected ListenersMap<Class> create(Class key) {
            return new ListenersMap<Class>();
        }
    });
    private ListenersMap<IWorldObjectId> specificObjectListeners = new ListenersMap();
    private Map<IWorldObjectId, ListenersMap<Class>> specificObjectEventListeners = Collections.synchronizedMap(new LazyMap<IWorldObjectId, ListenersMap<Class>>(){

        @Override
        protected ListenersMap<Class> create(IWorldObjectId key) {
            return new ListenersMap<Class>();
        }
    });
    private boolean raiseEventProcessing = false;
    private Queue<IWorldEvent> raiseEventsList = new ConcurrentLinkedQueue<IWorldEvent>();
    protected AgentLogger agentLogger;
    protected LogCategory log;

    public AbstractWorldView(AgentLogger logger) {
        this.agentLogger = logger;
        this.log = this.agentLogger.platform();
    }

    @Override
    public void addEventListener(Class<?> event, IWorldEventListener<?> listener) {
        this.eventListeners.add(event, listener);
    }

    @Override
    public void addObjectListener(Class<?> objectClass, IWorldObjectListener<?, IWorldObjectEvent<?>> listener) {
        this.objectsListeners.add(objectClass, listener);
    }

    @Override
    public void addObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectListener<?, ?> listener) {
        ListenersMap<Class> listeners = this.objectEventListeners.get(eventClass);
        listeners.add(objectClass, listener);
    }

    @Override
    public void addObjectListener(IWorldObjectId objectId, IWorldObjectListener<?, ?> listener) {
        this.specificObjectListeners.add(objectId, listener);
    }

    @Override
    public void addObjectListener(IWorldObjectId objectId, Class<?> eventClass, IWorldObjectListener<?, ?> listener) {
        ListenersMap<Class> listeners = this.specificObjectEventListeners.get(objectId);
        listeners.add(eventClass, listener);
    }

    @Override
    public boolean isListening(Class<?> eventClass, IWorldEventListener<?> listener) {
        return this.eventListeners.isListening(eventClass, listener);
    }

    @Override
    public boolean isListening(Class<?> objectClass, Class<?> eventClass, IWorldObjectListener<?, ?> listener) {
        if (this.objectEventListeners.containsKey(objectClass)) {
            return this.objectEventListeners.get(eventClass).isListening(objectClass, listener);
        }
        return false;
    }

    @Override
    public boolean isListening(IWorldObjectId objectId, IWorldObjectListener<?, ?> listener) {
        return this.specificObjectListeners.isListening(objectId, listener);
    }

    @Override
    public boolean isListening(IWorldObjectId objectId, Class<?> eventClass, IWorldObjectListener<?, ?> listener) {
        if (this.specificObjectEventListeners.containsKey(objectId)) {
            return this.specificObjectEventListeners.get(objectId).isListening(eventClass, listener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isListening(IWorldEventListener<?> listener) {
        if (this.eventListeners.isListening(listener) || this.specificObjectListeners.isListening(listener)) {
            return true;
        }
        Map<Serializable, ListenersMap<Class>> map = this.objectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.objectEventListeners.values()) {
                if (!listeners.isListening(listener)) continue;
                return true;
            }
        }
        map = this.specificObjectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.specificObjectEventListeners.values()) {
                if (!listeners.isListening(listener)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeEventListener(Class<?> eventClass, IWorldEventListener<?> listener) {
        this.eventListeners.remove(eventClass, listener);
    }

    @Override
    public void removeObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectListener<?, ?> listener) {
        if (this.objectEventListeners.containsKey(eventClass)) {
            this.objectEventListeners.get(eventClass).remove(objectClass, listener);
        }
    }

    @Override
    public void removeObjectListener(IWorldObjectId objectId, IWorldObjectListener<?, ?> listener) {
        this.specificObjectListeners.remove(objectId, listener);
    }

    @Override
    public void removeObjectListener(IWorldObjectId objectId, Class<?> eventClass, IWorldObjectListener<?, ?> listener) {
        if (this.specificObjectEventListeners.containsKey(objectId)) {
            this.specificObjectEventListeners.get(objectId).remove(eventClass, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IWorldEventListener<?> listener) {
        this.eventListeners.remove(listener);
        Map<Class, ListenersMap<Class>> map = this.objectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.objectEventListeners.values()) {
                listeners.remove(listener);
            }
        }
        this.specificObjectListeners.remove(listener);
        this.specificObjectEventListeners.remove(listener);
    }

    protected void addWorldObject(IWorldObject worldObject) {
        this.knownObjects.put(worldObject.getId(), worldObject);
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            this.syncWorldObjects.get(cls).put(worldObject.getId(), worldObject);
        }
    }

    protected void removeWorldObject(IWorldObject worldObject) {
        this.knownObjects.remove(worldObject.getId());
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            this.syncWorldObjects.get(cls).remove(worldObject.getId());
        }
    }

    @Override
    public Map<Class, Map<IWorldObjectId, IWorldObject>> getAll() {
        return this.syncWorldObjects;
    }

    @Override
    public <T extends IWorldObject> Map<IWorldObjectId, T> getAll(Class<T> type) {
        return this.syncWorldObjects.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IWorldObject> T getSingle(Class<T> cls) {
        Collection<T> col = this.getAll(cls).values();
        if (col.size() > 1) {
            throw new IllegalArgumentException("There must be at most one object of given class (" + cls.getName() + ") to use this method. But there were more instances (" + col.size() + ").");
        }
        if (col.size() < 1) {
            return null;
        }
        Collection<T> collection = col;
        synchronized (collection) {
            return (T)((IWorldObject)col.iterator().next());
        }
    }

    @Override
    public IWorldObject get(IWorldObjectId objectId) {
        return this.knownObjects.get(objectId);
    }

    @Override
    public Map<IWorldObjectId, IWorldObject> getObjects() {
        return this.knownObjects;
    }

    private void notifyLevelAListeners(IWorldEvent event) {
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        this.notifier.setEvent(event);
        for (Class eventClass : eventClasses) {
            this.eventListeners.notify(eventClass, this.notifier);
        }
    }

    private void notifyLevelBListeners(IWorldObjectEvent event) {
        Object object = event.getObject();
        Collection<Class> objectClasses = ClassUtils.getSubclasses(object.getClass());
        this.notifier.setEvent(event);
        for (Class objectClass : objectClasses) {
            this.objectsListeners.notify(objectClass, this.notifier);
        }
    }

    private void notifyLevelCListeners(IWorldObjectEvent event) {
        Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
        Collection<Class> objectClasses = ClassUtils.getSubclasses(event.getObject().getClass());
        this.notifier.setEvent(event);
        for (Class eventClass : eventClasses) {
            ListenersMap<Class> listeners = this.objectEventListeners.get(eventClass);
            if (listeners == null || !listeners.hasListeners()) continue;
            for (Class objectClass : objectClasses) {
                listeners.notify(objectClass, this.notifier);
            }
        }
    }

    private void notifyLevelDListeners(IWorldObjectEvent event) {
        this.notifier.setEvent(event);
        this.specificObjectListeners.notify(event.getId(), this.notifier);
    }

    private void notifyLevelEListeners(IWorldObjectEvent event) {
        this.notifier.setEvent(event);
        IWorldObjectId objectId = event.getId();
        ListenersMap<Class> listeners = this.specificObjectEventListeners.get(objectId);
        if (listeners.hasListeners()) {
            Collection<Class> eventClasses = ClassUtils.getSubclasses(event.getClass());
            this.notifier.setEvent(event);
            for (Class eventClass : eventClasses) {
                listeners.notify(eventClass, this.notifier);
            }
        }
    }

    private void innerRaiseEvent(IWorldEvent event) {
        this.log.fine("WV: notifying " + event);
        this.notifyLevelAListeners(event);
        if (event instanceof IWorldObjectEvent) {
            IWorldObjectEvent objectEvent = (IWorldObjectEvent)event;
            this.notifyLevelBListeners(objectEvent);
            this.notifyLevelCListeners(objectEvent);
            this.notifyLevelDListeners(objectEvent);
            this.notifyLevelEListeners(objectEvent);
        }
    }

    protected synchronized void raiseEvent(IWorldEvent event) {
        if (this.raiseEventProcessing) {
            this.raiseEventsList.add(event);
            return;
        }
        this.raiseEventProcessing = true;
        this.innerRaiseEvent(event);
        while (this.raiseEventsList.size() != 0) {
            this.innerRaiseEvent(this.raiseEventsList.poll());
        }
        this.raiseEventProcessing = false;
    }

    private static class ListenerNotifier<T>
    implements Listeners.ListenerNotifier<IListener> {
        private T event = null;

        private ListenerNotifier() {
        }

        public void setEvent(T event) {
            this.event = event;
        }

        @Override
        public void notify(IListener listener) {
            listener.notify(this.event);
        }
    }
}

