/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.connection.socket;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.connection.AbstractConnection;
import cz.cuni.amis.pogamut.base.communication.connection.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.exceptions.ConnectionException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;

@AgentScoped
public class SocketConnection
extends AbstractConnection<ISocketConnectionAddress> {
    private Socket socket = null;
    private InputStreamReader socketReader = null;
    private OutputStreamWriter socketWriter = null;

    @Inject
    public SocketConnection(AgentLogger logger) {
        super(logger);
    }

    @Override
    protected Reader getConnectionReader() throws ConnectionException {
        return this.socketReader;
    }

    @Override
    protected Writer getConnectionWriter() throws ConnectionException {
        return this.socketWriter;
    }

    @Override
    protected void unsyncClose() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "SocketConnection: can't close socket - " + e.getMessage());
            }
            try {
                this.socketReader.close();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "SocketConnection: can't close socket reader - " + e.getMessage());
            }
            try {
                this.socketWriter.close();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "SocketConnection: can't close socket writer - " + e.getMessage());
            }
        }
    }

    @Override
    protected void unsyncConnect(ISocketConnectionAddress address) throws ConnectionException {
        this.socket = new Socket();
        try {
            this.socket.connect(new InetSocketAddress(address.getHost(), address.getPort()));
            this.socketReader = new InputStreamReader(this.socket.getInputStream());
            this.socketWriter = new OutputStreamWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            throw new ConnectionException(e.getMessage(), e, (Object)this.log);
        }
    }
}

