/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.connection;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnection;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.exceptions.ConnectionException;
import cz.cuni.amis.pogamut.base.exceptions.PogamutIOException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.StringCutter;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;

@AgentScoped
public abstract class AbstractConnection<ConnectionAddress extends IWorldConnectionAddress>
implements IWorldConnection<ConnectionAddress> {
    private int connectionToken = 0;
    private Object classMutex = new Object();
    private Flag<Boolean> connected = new Flag<Boolean>(false);
    protected ConnectionAddress address = null;
    private ConnectionWriter writer = new ConnectionWriter(this);
    private ConnectionReader reader = new ConnectionReader(this);
    private Object loggerAccessMutex = new Object();
    private AgentLogger agentLogger = null;
    protected LogCategory log = null;

    protected abstract void unsyncConnect(ConnectionAddress var1) throws ConnectionException;

    @Inject
    public AbstractConnection(AgentLogger logger) {
        this.agentLogger = logger;
        this.log = this.agentLogger.in();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ConnectionAddress address) throws ConnectionException {
        Object object = this.classMutex;
        synchronized (object) {
            if (address == null) {
                throw new ConnectionException("address is null, can't do connect()", this.log, (Object)this);
            }
            if (this.isConnected() && address.equals(this.address)) {
                this.close();
            }
            this.address = address;
            this.unsyncConnect(this.address);
            this.connected.setFlag(true);
        }
    }

    protected abstract void unsyncClose();

    protected abstract Reader getConnectionReader() throws ConnectionException;

    protected abstract Writer getConnectionWriter() throws ConnectionException;

    public String getMessageEnd() {
        return "\r\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.classMutex;
        synchronized (object) {
            if (!this.isConnected()) {
                return;
            }
            this.reader.reader = null;
            this.writer.writer = null;
            this.unsyncClose();
            ++this.connectionToken;
            this.connected.setFlag(false);
        }
    }

    public boolean isConnected() {
        return this.connected.getFlag();
    }

    @Override
    public ImmutableFlag<Boolean> getConnected() {
        return this.connected.getImmutable();
    }

    @Override
    public Writer getWriter() throws ConnectionException {
        return this.writer;
    }

    public void finalize() {
        this.close();
    }

    @Override
    public Reader getReader() throws ConnectionException {
        return this.reader;
    }

    @Override
    public ConnectionAddress getAddress() {
        return this.address;
    }

    public String toString() {
        return this.getClass().getName() + "(" + String.valueOf(this.address) + ",connected:" + this.isConnected() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(Level level, String message) {
        Object object = this.loggerAccessMutex;
        synchronized (object) {
            if (this.log != null) {
                this.log.log(level, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(Level level, String message, Object obj) {
        Object object = this.loggerAccessMutex;
        synchronized (object) {
            if (this.log != null) {
                this.log.log(level, message, obj);
            }
        }
    }

    @Override
    public void setLogMessages(boolean logMessages) {
        this.reader.setLogMessages(logMessages);
        this.writer.setLogMessages(logMessages);
    }

    private class ConnectionWriter
    extends Writer {
        private AbstractConnection<ConnectionAddress> owner = null;
        private StringCutter line = new StringCutter(AbstractConnection.this.getMessageEnd());
        private Writer writer = null;
        private int currentConnectionToken = -1;
        private Object logMessagesMutex = new Object();
        private boolean logMessages = false;

        public ConnectionWriter(AbstractConnection<ConnectionAddress> owner) {
            this.owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLogMessages(boolean state) {
            Object object = this.logMessagesMutex;
            synchronized (object) {
                if (this.logMessages == state) {
                    return;
                }
                this.logMessages = state;
                if (this.logMessages) {
                    this.line.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Writer getWriter() throws PogamutIOException {
            Object object = AbstractConnection.this.classMutex;
            synchronized (object) {
                if (this.currentConnectionToken != AbstractConnection.this.connectionToken || this.writer == null) {
                    this.currentConnectionToken = AbstractConnection.this.connectionToken;
                    this.line.clear();
                    this.writer = AbstractConnection.this.getConnectionWriter();
                }
                return this.writer;
            }
        }

        @Override
        public void close() {
            this.owner.close();
        }

        @Override
        public void flush() throws IOException {
            Writer currentWriter;
            try {
                currentWriter = this.getWriter();
            }
            catch (PogamutIOException e1) {
                e1.logExceptionOnce(AbstractConnection.this.log);
                throw new IOException("can't get connection writer");
            }
            if (currentWriter != null) {
                currentWriter.flush();
            }
        }

        public boolean ready() throws PogamutIOException {
            if (!AbstractConnection.this.isConnected()) {
                return false;
            }
            Writer currentWriter = this.getWriter();
            return currentWriter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkedClose() {
            if (AbstractConnection.this.isConnected()) {
                Object object = AbstractConnection.this.classMutex;
                synchronized (object) {
                    if (this.currentConnectionToken == AbstractConnection.this.connectionToken) {
                        this.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void write(char[] cbuf, int off, int len) throws IOException {
            Writer currentWriter;
            if (!AbstractConnection.this.isConnected()) {
                AbstractConnection.this.log.severe("not connected, can't write");
                throw new IOException("not connected, can't write");
            }
            try {
                currentWriter = this.getWriter();
            }
            catch (PogamutIOException e1) {
                e1.logExceptionOnce(AbstractConnection.this.log);
                throw new IOException("can't get writer for the connection");
            }
            if (currentWriter == null) {
                this.checkedClose();
                AbstractConnection.this.log.severe("inner reader of the connection is null, can't read");
                throw new IOException("inner reader of the connection is null, can't read");
            }
            try {
                currentWriter.write(cbuf, off, len);
            }
            catch (IOException e) {
                this.checkedClose();
                AbstractConnection.this.log.severe(ExceptionToString.process("write failed", e));
                throw e;
            }
            Object object = this.logMessagesMutex;
            synchronized (object) {
                if (this.logMessages) {
                    String[] lines = this.line.add(new String(cbuf, off, len));
                    for (int index = 0; index < lines.length; ++index) {
                        AbstractConnection.this.log(Level.INFO, "Message written: " + lines[index]);
                    }
                }
            }
        }
    }

    private class ConnectionReader
    extends Reader {
        private AbstractConnection<ConnectionAddress> owner = null;
        private StringCutter line = new StringCutter(AbstractConnection.this.getMessageEnd());
        private Reader reader = null;
        private int currentConnectionToken = -1;
        private Object logMessagesMutex = new Object();
        private boolean logMessages = false;

        public ConnectionReader(AbstractConnection<ConnectionAddress> owner) {
            this.owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLogMessages(boolean state) {
            Object object = this.logMessagesMutex;
            synchronized (object) {
                if (this.logMessages == state) {
                    return;
                }
                this.logMessages = state;
                if (this.logMessages) {
                    this.line.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Reader getReader() throws PogamutIOException {
            Object object = AbstractConnection.this.classMutex;
            synchronized (object) {
                if (this.currentConnectionToken != AbstractConnection.this.connectionToken || this.reader == null) {
                    this.currentConnectionToken = AbstractConnection.this.connectionToken;
                    this.line.clear();
                    this.reader = AbstractConnection.this.getConnectionReader();
                }
                return this.reader;
            }
        }

        @Override
        public void close() {
            this.owner.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkedClose() {
            if (AbstractConnection.this.isConnected()) {
                Object object = AbstractConnection.this.classMutex;
                synchronized (object) {
                    if (this.currentConnectionToken == AbstractConnection.this.connectionToken) {
                        this.close();
                    }
                }
            }
        }

        @Override
        public boolean ready() throws IOException {
            Reader currentReader;
            if (!AbstractConnection.this.isConnected()) {
                return false;
            }
            try {
                currentReader = this.getReader();
            }
            catch (PogamutIOException e1) {
                e1.logExceptionOnce(AbstractConnection.this.log);
                throw new IOException("can't get reader for the connection");
            }
            if (currentReader != null) {
                return currentReader.ready();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(char[] ac, int i, int j) throws IOException {
            int result;
            Reader currentReader;
            if (!AbstractConnection.this.isConnected()) {
                throw new IOException("not connected, can't read");
            }
            try {
                currentReader = this.getReader();
            }
            catch (PogamutIOException e1) {
                e1.logExceptionOnce(AbstractConnection.this.log);
                throw new IOException("can't get reader for the connection");
            }
            if (currentReader == null) {
                this.checkedClose();
                IOException e = new IOException("inner reader of the connection is null, can't read");
                AbstractConnection.this.log.severe(ExceptionToString.process(e));
                throw e;
            }
            try {
                result = currentReader.read(ac, i, j);
            }
            catch (IOException e) {
                this.checkedClose();
                AbstractConnection.this.log.severe("read failed: " + e.getMessage());
                throw e;
            }
            Object object = this.logMessagesMutex;
            synchronized (object) {
                if (this.logMessages) {
                    String[] lines = this.line.add(new String(ac, i, result));
                    for (int index = 0; index < lines.length; ++index) {
                        AbstractConnection.this.log(Level.INFO, "Message read: " + lines[index]);
                    }
                    return result;
                }
                return result;
            }
        }
    }
}

