/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.commands;

import cz.cuni.amis.pogamut.base.communication.commands.IAct;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommandException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.utils.listener.Listeners;

@AgentScoped
public class Act
implements IAct {
    private MessageListenerNotifier notifier = new MessageListenerNotifier();
    protected Listeners<ICommandListener> commandListeners = new Listeners();
    private ICommandSerializer serializer;
    private AgentLogger log;

    public Act(ICommandSerializer serializer, AgentLogger logger) {
        this.serializer = serializer;
        this.log = logger;
    }

    @Override
    public synchronized void act(CommandMessage command) throws CommandException {
        try {
            this.serializer.sendCommand(command);
        }
        catch (Exception e) {
            this.serializer.stop();
            throw new CommandException("Could not serialize the command: " + e.toString(), e, (Object)this.log);
        }
        if (this.commandListeners.count() > 0) {
            this.notifier.setMessage(command);
            this.commandListeners.notify(this.notifier);
        }
    }

    @Override
    public void addCommandListener(ICommandListener listener) {
        this.commandListeners.addWeakListener(listener);
    }

    @Override
    public void removeCommandListener(ICommandListener listener) {
        this.commandListeners.removeListener(listener);
    }

    private static class MessageListenerNotifier
    implements Listeners.ListenerNotifier<ICommandListener> {
        private CommandMessage msg;

        private MessageListenerNotifier() {
        }

        public void setMessage(CommandMessage msg) {
            this.msg = msg;
        }

        @Override
        public void notify(ICommandListener listener) {
            listener.notify(this.msg);
        }
    }
}

