/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.AbstractPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;
import java.util.LinkedList;
import java.util.List;

public class TripExecutor<T extends ILocated>
extends AbstractPathExecutor<List<T>> {
    PathExecutor<ILocated> executor = null;
    List<? extends ILocated> targets = null;
    List<? extends ILocated> lastTrip = null;

    public TripExecutor(PathExecutor<ILocated> executor) {
        this.executor = executor;
        executor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                if (eventType.equals((Object)PathEventType.TARGET_REACHED)) {
                    TripExecutor.this.moveToNext();
                }
            }
        });
    }

    @Override
    public void goTo(List<T> trip) {
        if (trip != this.lastTrip) {
            this.lastTrip = trip;
            this.targets = new LinkedList<T>(trip);
            this.moveToNext();
        }
    }

    protected void moveToNext() {
        if (this.targets.isEmpty()) {
            this.fireEvent(PathEventType.TARGET_REACHED);
        } else {
            ILocated loc = this.targets.remove(0);
            this.executor.goTo(loc);
        }
    }
}

