/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.jmx;

import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.jmx.AgentMBeanAdapterMBean;
import cz.cuni.amis.utils.flag.jmx.JMXFlagDecorator;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class AgentMBeanAdapter<T extends IAgent>
implements AgentMBeanAdapterMBean {
    public static final String AGENT_STATE_FLAG_NAME = "agent_state_flag";
    T agent = null;
    JMXFlagDecorator<AgentState> jmxAgentState = null;

    public AgentMBeanAdapter(T agent, ObjectName objectName, MBeanServer mbs) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.agent = agent;
        this.jmxAgentState = new JMXFlagDecorator<AgentState>(agent.getAgentState(), objectName, mbs, AGENT_STATE_FLAG_NAME);
    }

    protected T getAgent() {
        return this.agent;
    }

    public ObjectName getObjectName(String domain) throws MalformedObjectNameException {
        return ObjectName.getInstance(domain + ":name=" + this.agent.getName() + ",type=agent");
    }

    @Override
    public String getName() {
        return this.agent.getName();
    }

    @Override
    public String getDisplayName() {
        return this.agent.getDisplayName();
    }

    @Override
    public AgentState getAgentState() {
        return this.agent.getAgentState().getFlag();
    }

    @Override
    public void start() throws AgentException {
        this.agent.start();
    }

    @Override
    public void pause() throws AgentException {
        this.agent.pause();
    }

    @Override
    public void resume() throws AgentException {
        this.agent.resume();
    }

    @Override
    public void stop() throws AgentException {
        this.agent.stop();
    }

    @Override
    public void kill() {
        this.agent.kill();
    }
}

