/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.jmx;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.jmx.DynamicMBeanToFolderAdapter;
import cz.cuni.amis.introspection.jmx.DynamicProxy;
import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.utils.FolderToIJMXEnabledAdapter;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.AgentLoggerJMXProxy;
import cz.cuni.amis.utils.Lazy;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.jmx.FlagJMXProxy;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class AgentJMXProxy
implements IAgent {
    FlagJMXProxy<AgentState> agentFlag = null;
    DynamicProxy proxy = null;
    private Lazy<AgentLogger> agentLogger = new Lazy<AgentLogger>(){

        @Override
        protected AgentLogger create() {
            return new AgentLoggerJMXProxy(AgentJMXProxy.this.mbsc, AgentJMXProxy.this.agentName);
        }
    };
    private Lazy<Folder> folder = new Lazy<Folder>(){

        @Override
        protected Folder create() {
            try {
                ObjectName introspectionRoot = FolderToIJMXEnabledAdapter.getFolderObjectNameForParent(AgentJMXProxy.this.agentName, "root");
                DynamicProxy proxy = new DynamicProxy(introspectionRoot, AgentJMXProxy.this.mbsc);
                return new DynamicMBeanToFolderAdapter(proxy);
            }
            catch (MalformedObjectNameException ex) {
                throw new RuntimeException(ex);
            }
        }
    };
    MBeanServerConnection mbsc = null;
    ObjectName agentName = null;

    public AgentJMXProxy(MBeanServerConnection mbsc, ObjectName agentName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AgentJMXProxy(String agentJmxAddress) throws MalformedURLException, IOException, MalformedObjectNameException {
        String[] strs = agentJmxAddress.split("\\|");
        String jmxService = strs[0];
        String objectName = strs[1];
        JMXServiceURL url = new JMXServiceURL(jmxService);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        this.mbsc = jmxc.getMBeanServerConnection();
        this.agentName = ObjectName.getInstance(objectName);
        this.proxy = new DynamicProxy(this.agentName, this.mbsc);
        this.agentFlag = new FlagJMXProxy(this.agentName, this.mbsc, "agent_state_flag");
    }

    @Override
    public AgentLogger getLogger() {
        return this.agentLogger.getVal();
    }

    @Override
    public ImmutableFlag<AgentState> getAgentState() {
        return this.agentFlag.getImmutable();
    }

    public ImmutableFlag<String> getAgentStateDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Object callNoException(String actionName) {
        try {
            return this.call(actionName);
        }
        catch (AgentException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object callNoException(String actionName, Object[] params, String[] sig) {
        try {
            return this.proxy.invoke(actionName, params, sig);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object call(String actionName) throws AgentException {
        try {
            return this.proxy.invoke(actionName, null, null);
        }
        catch (Exception ex) {
            throw new AgentException("JMX communication exception. Error executing method :" + actionName + ".", ex, (Object)this);
        }
    }

    protected Object getAttributeNoException(String atr) {
        try {
            return this.proxy.getAttribute(atr);
        }
        catch (Exception ex) {
            throw new RuntimeException("Atribute retrieval error.", ex);
        }
    }

    @Override
    public void start() throws AgentException {
        this.call("start");
    }

    @Override
    public void pause() throws AgentException {
        this.call("pause");
    }

    @Override
    public void resume() throws AgentException {
        this.call("resume");
    }

    @Override
    public void stop() {
        this.callNoException("stop");
    }

    @Override
    public void kill() {
        this.callNoException("kill");
    }

    @Override
    public String getName() {
        return (String)this.getAttributeNoException("Name");
    }

    @Override
    public String getDisplayName() {
        return (String)this.getAttributeNoException("DisplayName");
    }

    @Override
    public Folder getFolder() {
        return this.folder.getVal();
    }
}

