/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.jmx;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.agent.jmx.AgentMBeanAdapter;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.IJMXEnabled;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutJMX;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

@AgentScoped
public class AgentJMX<T extends IAgent> {
    public static final String JMX_SERVER_AGENT_NAME_DELIM = "|";
    private MBeanServer mBeanServer = null;
    private String jmxDomain = null;
    private List<IJMXEnabled> jmxComponents = new ArrayList<IJMXEnabled>();
    private ObjectName agentJMXName = null;
    private AgentLogger agentLogger;
    private LogCategory log;
    private T agent;

    @Inject
    public AgentJMX(T agent) {
        this.agent = agent;
        this.agentLogger = agent.getLogger();
        this.log = this.agentLogger.platform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(IJMXEnabled component) {
        List<IJMXEnabled> list = this.jmxComponents;
        synchronized (list) {
            this.jmxComponents.add(component);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public String getJMXDomain() {
        return this.jmxDomain;
    }

    public boolean isJMXEnabled() {
        return this.jmxDomain != null;
    }

    public ObjectName getAgentJMXName() {
        return this.agentJMXName;
    }

    private String testJMXDomainName(String jmxDomain) {
        try {
            new ObjectName(PogamutJMX.getJMXName(jmxDomain, "testType", "testName"));
        }
        catch (MalformedObjectNameException e) {
            String newJmxDomain = "jmxDomainMalformed_" + UUID.randomUUID().toString();
            this.log.warning("Domain name '" + jmxDomain + "' probably malformed, trying to change to '" + newJmxDomain + "'.");
            try {
                new ObjectName(PogamutJMX.getJMXName(newJmxDomain, "testType", "testName"));
            }
            catch (MalformedObjectNameException e1) {
                this.log.severe("Domain name '" + newJmxDomain + "' seems also malformed, can't start JMX.");
                return null;
            }
            catch (NullPointerException e1) {
                this.log.severe("Domain name '" + newJmxDomain + "' seems also malformed.");
                return null;
            }
            return newJmxDomain;
        }
        catch (NullPointerException e) {
            this.log.log(Level.SEVERE, "Can't create object name with domain '" + jmxDomain + "'.");
            return null;
        }
        return jmxDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableJMX(MBeanServer mBeanServer) throws JMXAlreadyEnabledException, CantStartJMXException {
        boolean exception = false;
        List<IJMXEnabled> list = this.jmxComponents;
        synchronized (list) {
            if (this.isJMXEnabled()) {
                throw new JMXAlreadyEnabledException("JMX is already enabled on the agent.", this.log);
            }
            this.jmxDomain = Pogamut.getPlatform().getProperty("pogamut.jmx.domain");
            try {
                this.agentJMXName = ObjectName.getInstance(this.jmxDomain + ":name=" + this.agent.getName().replace('.', '_') + ",type=agent");
            }
            catch (MalformedObjectNameException ex) {
                throw new CantStartJMXException("Malformed agent ObjectName.", (Object)ex);
            }
            try {
                AgentMBeanAdapter agentMBean = this.createAgentMBean(this.agentJMXName, mBeanServer);
                mBeanServer.registerMBean(agentMBean, this.agentJMXName);
            }
            catch (Exception ex) {
                throw new CantStartJMXException("Agent MBeans cannot be registered.", ex, (Object)this.log);
            }
            for (IJMXEnabled jmxComponent : this.jmxComponents) {
                try {
                    jmxComponent.enableJMX(mBeanServer, this.agentJMXName);
                }
                catch (JMXAlreadyEnabledException e) {
                    exception = true;
                    this.log.log(Level.SEVERE, ExceptionToString.process("JMXComponent(class=" + jmxComponent.getClass().getName() + ",name=" + jmxComponent.toString() + ") states that it's already enabled.", e));
                }
                catch (CantStartJMXException e) {
                    exception = true;
                    this.log.severe(ExceptionToString.process("JMXComponent(class=" + jmxComponent.getClass().getName() + ",name=" + jmxComponent.toString() + ") can't start it's JMX.", e));
                }
            }
        }
        return !exception;
    }

    public static ObjectName getObjectName(ObjectName parent, String name, String typeExtra) throws MalformedObjectNameException {
        String extType = parent.getKeyProperty("type") + "." + parent.getKeyProperty("name") + (typeExtra != null ? "." + typeExtra : "");
        String pre = parent.getDomain() + ":type=";
        String post = name != null ? ",name=" + name : "";
        String jmxObjName = pre + extType + post;
        return ObjectName.getInstance(jmxObjName);
    }

    protected AgentMBeanAdapter createAgentMBean(ObjectName objectName, MBeanServer mbs) throws MalformedObjectNameException, InstanceAlreadyExistsException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return new AgentMBeanAdapter<T>(this.agent, objectName, mbs);
    }
}

