/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent;

import java.util.EnumSet;
import java.util.Set;

public enum AgentStateType {
    INSTANTIATED,
    INIT,
    RUNNING,
    DEBUG_PAUSED,
    PAUSED,
    END,
    FAILED;

    private static Set<AgentStateType> instantiatedStates;
    private static Set<AgentStateType> initStates;
    private static Set<AgentStateType> okStates;
    private static Set<AgentStateType> pausedStates;
    private static Set<AgentStateType> endStates;
    private static Set<AgentStateType> nonResponsiveStates;

    public boolean isInstantiatedState() {
        return instantiatedStates.contains((Object)this);
    }

    public boolean isInitState() {
        return initStates.contains((Object)this);
    }

    public boolean isOKState() {
        return okStates.contains((Object)this);
    }

    public boolean isPausedState() {
        return pausedStates.contains((Object)this);
    }

    public boolean isEndState() {
        return endStates.contains((Object)this);
    }

    public boolean isNonResponsiveState() {
        return nonResponsiveStates.contains((Object)this);
    }

    static {
        instantiatedStates = EnumSet.of(INSTANTIATED);
        initStates = EnumSet.of(INIT);
        okStates = EnumSet.of(RUNNING, PAUSED, DEBUG_PAUSED);
        pausedStates = EnumSet.of(PAUSED, DEBUG_PAUSED);
        endStates = EnumSet.of(END, FAILED);
        nonResponsiveStates = EnumSet.of(FAILED, DEBUG_PAUSED);
    }
}

