/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent;

import cz.cuni.amis.pogamut.base.agent.AbstractEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.utils.reason.IReasonRunningChanged;
import cz.cuni.amis.pogamut.base.communication.utils.reason.ReasonException;
import cz.cuni.amis.pogamut.base.communication.utils.reason.ReasonStopped;
import cz.cuni.amis.pogamut.base.communication.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import java.util.logging.Level;

public abstract class AbstractThreadedEmbodiedAgent
extends AbstractEmbodiedAgent {
    private Object mutex = new Object();
    private Thread thread = null;
    private Flag<Boolean> paused = new Flag<Boolean>(false);
    private boolean shouldRun = true;
    private Logic logic;
    private double frequency = 5.0;
    private double period = 200.0;
    private long lastLogicRun = 0L;

    public AbstractThreadedEmbodiedAgent(AgentLogger logger, IStartableWorldView worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
    }

    protected abstract void startupAgent();

    protected abstract void doAgentLogic();

    protected abstract void shutdownAgent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws AgentException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.thread != null) {
                throw new AgentException("Can't start agent, thread still exists.", this);
            }
            this.logic = new Logic();
            this.thread = new Thread(this.logic);
        }
        super.start();
        this.shouldRun = true;
        this.paused.setFlag(false);
        this.thread.start();
    }

    @Override
    public void stop() {
        this.logPlatform(Level.WARNING, this + ": stop()ing agent");
        this.paused.setFlag(false);
        this.shouldRun = false;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() {
        this.logPlatform(Level.WARNING, this + ": kill()ing agent");
        this.paused.setFlag(false);
        this.shouldRun = false;
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        super.kill();
    }

    @Override
    public void pause() throws AgentException {
        this.logPlatform(Level.WARNING, this + ": Pausing agent");
        this.paused.setFlag(true);
    }

    @Override
    public void resume() throws AgentException {
        this.logPlatform(Level.WARNING, this + ": Resuming agent");
        this.paused.setFlag(false);
    }

    public double getLogicFrequency() {
        return this.frequency;
    }

    public void setLogicFrequency(double frequency) {
        if (frequency <= 0.0) {
            this.frequency = -1.0;
            this.period = -1.0;
        } else {
            this.frequency = frequency;
            this.period = 1000.0 / this.frequency;
        }
    }

    private class Logic
    implements Runnable {
        private Logic() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IReasonRunningChanged reason = null;
            AbstractThreadedEmbodiedAgent.this.startupAgent();
            try {
                while (AbstractThreadedEmbodiedAgent.this.shouldRun && !Thread.currentThread().isInterrupted()) {
                    if (((Boolean)AbstractThreadedEmbodiedAgent.this.paused.getFlag()).booleanValue()) {
                        AbstractThreadedEmbodiedAgent.this.setAgentState(AgentStateType.PAUSED, "Agent paused.");
                        new WaitForFlagChange<Boolean>(AbstractThreadedEmbodiedAgent.this.paused, false).await();
                    }
                    if (AbstractThreadedEmbodiedAgent.this.period > 0.0 && (double)(System.currentTimeMillis() - AbstractThreadedEmbodiedAgent.this.lastLogicRun) <= AbstractThreadedEmbodiedAgent.this.period) {
                        Thread.sleep(new Double(AbstractThreadedEmbodiedAgent.this.period - (double)(System.currentTimeMillis() - AbstractThreadedEmbodiedAgent.this.lastLogicRun)).intValue());
                    }
                    AbstractThreadedEmbodiedAgent.this.lastLogicRun = System.currentTimeMillis();
                    AbstractThreadedEmbodiedAgent.this.doAgentLogic();
                }
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedException)) {
                    reason = new ReasonException(e);
                    try {
                        AbstractThreadedEmbodiedAgent.this.kill();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (reason == null) {
                    reason = new ReasonStopped();
                }
                Object e = AbstractThreadedEmbodiedAgent.this.mutex;
                synchronized (e) {
                    AbstractThreadedEmbodiedAgent.this.thread = null;
                }
                try {
                    AbstractThreadedEmbodiedAgent.this.shutdownAgent();
                }
                catch (Exception e2) {
                    AbstractThreadedEmbodiedAgent.this.logPlatform(Level.SEVERE, ExceptionToString.process("shutdownAgent() exception", e2));
                }
                if (reason instanceof ReasonException) {
                    AbstractThreadedEmbodiedAgent.this.setAgentState(new AgentState(AgentStateType.FAILED, "Exception: " + ((ReasonException)reason).getException().getMessage()));
                } else {
                    AbstractThreadedEmbodiedAgent.this.setAgentState(new AgentState(AgentStateType.END, "Agent stopped."));
                }
            }
        }
    }
}

