/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.communication.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;

@AgentScoped
public abstract class AbstractObservingAgent<WORLD_VIEW extends IStartableWorldView>
extends AbstractAgent {
    private WORLD_VIEW worldView;

    @Inject
    public AbstractObservingAgent(AgentLogger logger, WORLD_VIEW worldView) {
        super(logger);
        this.worldView = worldView;
    }

    protected WORLD_VIEW getWorldView() {
        return this.worldView;
    }

    @Override
    public void start() throws AgentException {
        try {
            this.worldView.start();
        }
        catch (PogamutException ex) {
            throw new AgentException("Exception occured during world view startup.", ex, (Object)this.getLogger().platform());
        }
    }

    @Override
    public void kill() {
        this.worldView.kill();
    }

    @Override
    public void stop() {
        this.worldView.stop();
    }
}

