/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.AbstractObservingAgent;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.communication.commands.Act;
import cz.cuni.amis.pogamut.base.communication.commands.IAct;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;

@AgentScoped
public abstract class AbstractGhostAgent<WORLD_VIEW extends IStartableWorldView>
extends AbstractObservingAgent<WORLD_VIEW>
implements IGhostAgent {
    private AgentAct act;
    private ICommandSerializer commandSerializer;

    @Inject
    public AbstractGhostAgent(AgentLogger logger, WORLD_VIEW worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView);
        this.commandSerializer = commandSerializer;
        this.act = new AgentAct(commandSerializer);
    }

    @Override
    public AgentAct getAct() {
        return this.act;
    }

    @Override
    public void start() throws AgentException {
        try {
            this.commandSerializer.start();
        }
        catch (CommunicationException e) {
            throw new AgentException("Can't start the agent.", (Throwable)e, this.getLogger().platform(), this);
        }
        super.start();
    }

    public class AgentAct
    implements IAct {
        private Act act;

        public AgentAct(ICommandSerializer serializer) {
            this.act = new Act(serializer, AbstractGhostAgent.this.getLogger());
        }

        public Act getAct() {
            return this.act;
        }

        @Override
        public void act(CommandMessage command) {
            try {
                this.act.act(command);
            }
            catch (CommunicationException e) {
                e.logExceptionOnce(AbstractGhostAgent.this.getLogger().platform());
                AbstractGhostAgent.this.terminate(AgentStateType.FAILED, e.getMessage(), AbstractGhostAgent.this.getAgentStopTimeoutMillis());
            }
        }

        @Override
        public void addCommandListener(ICommandListener listener) {
            this.act.addCommandListener(listener);
        }

        @Override
        public void removeCommandListener(ICommandListener listener) {
            this.act.removeCommandListener(listener);
        }
    }
}

