/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent;

import com.google.inject.Inject;
import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.java.ReflectionObjectFolder;
import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.jmx.AgentJMX;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.exceptions.PogamutRuntimeException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.FolderToIJMXEnabledAdapter;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.utils.Job;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.InterruptedRuntimeException;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

@AgentScoped
public abstract class AbstractAgent
implements IAgent {
    private static int agentCounter = 0;
    public static final String INTROSPECTION_ROOT_NAME = "root";
    public static final long DEFAULT_AGENT_TIMEOUT_MILLIS = 2000L;
    private AgentLogger logger = null;
    private Flag<AgentState> agentState = new Flag<AgentState>(new AgentState(AgentStateType.INSTANTIATED, "Created."));
    private Flag<String> agentStateDescription = new Flag<String>("Just created");
    private AgentJMX jmx = null;
    private Folder folder = null;

    @Inject
    public AbstractAgent(AgentLogger logger) {
        this.logger = logger;
        this.agentInit();
    }

    private void agentInit() {
        this.logPlatform(Level.FINEST, "AbstractAgent init - done.");
    }

    @Override
    public AgentLogger getLogger() {
        return this.logger;
    }

    protected void log(Level level, String message) {
        this.logger.user().log(level, message);
    }

    protected void logPlatform(Level level, String message) {
        this.logger.platform().log(level, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAgentState(AgentState state) {
        Flag<AgentState> flag = this.agentState;
        synchronized (flag) {
            this.logPlatform(Level.FINER, "Agent state is going to be switched to: " + state.toString());
            this.agentState.setFlag(state);
            this.logPlatform(Level.INFO, "Agent state switched to: " + state.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAgentState(AgentStateType state, String description) {
        Flag<AgentState> flag = this.agentState;
        synchronized (flag) {
            this.setAgentState(new AgentState(state, description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAgentStateDescription(String description) {
        Flag<AgentState> flag = this.agentState;
        synchronized (flag) {
            this.setAgentState(new AgentState(this.agentState.getFlag().getType(), description));
        }
    }

    @Override
    public ImmutableFlag<AgentState> getAgentState() {
        return this.agentState.getImmutable();
    }

    @Override
    public String getName() {
        try {
            return this.getClass().getSimpleName() + ++agentCounter + "@" + InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            return this.getClass().getSimpleName() + ++agentCounter + "@unknownHost";
        }
    }

    protected void addAgentJMXComponents() {
        this.jmx.addComponent(this.logger);
        this.jmx.addComponent(new FolderToIJMXEnabledAdapter(this.getFolder()));
    }

    public synchronized AgentJMX getJMX() {
        if (this.jmx == null) {
            this.jmx = this.createAgentJMX();
            this.addAgentJMXComponents();
        }
        return this.jmx;
    }

    @Override
    public abstract void start() throws AgentException;

    @Override
    public abstract void pause() throws AgentException;

    @Override
    public abstract void resume() throws AgentException;

    @Override
    public abstract void stop();

    @Override
    public abstract void kill();

    public long getAgentStopTimeoutMillis() {
        return 2000L;
    }

    public void terminate() {
        this.terminate(this.getAgentStopTimeoutMillis());
    }

    public void terminate(long agentStopTimeoutMillis) {
        this.terminate(null, null, agentStopTimeoutMillis);
    }

    protected synchronized void terminate(AgentStateType resultState, String description, long agentStopTimeoutMillis) {
        this.getLogger().platform().warning(this + ".terminateAgent(): terminateAgent() called");
        Job<Boolean> stopAgent = new Job<Boolean>(){

            @Override
            protected void job() throws AgentException {
                AbstractAgent.this.stop();
                this.setResult(true);
            }
        };
        try {
            stopAgent.startJob().await(agentStopTimeoutMillis);
        }
        catch (InterruptedException e) {
            this.getLogger().platform().severe(this + ".terminateAgent(): interrupted during stop()ing of the agent.");
        }
        if (!stopAgent.isFinishedOk()) {
            stopAgent.interrupt();
            if (stopAgent.isException() && stopAgent.getException() instanceof PogamutException) {
                ((PogamutException)stopAgent.getException()).logExceptionOnce(this.getLogger().platform());
            }
            this.getLogger().platform().severe(this + ".terminateAgent(): stop()ing agent failed, trying to kill");
            this.kill();
        }
        if (resultState != null) {
            if (!resultState.isEndState()) {
                this.getLogger().platform().warning(this + ".terminateAgent(): newState is not one of the end states (is " + (Object)((Object)resultState) + "), state not changed");
            } else if (description == null) {
                this.setAgentState(resultState, "Agent terminated");
            } else {
                this.setAgentState(resultState, description);
            }
        } else if (description != null) {
            this.setAgentStateDescription(description);
        }
    }

    @Override
    public Folder getFolder() {
        if (this.folder == null) {
            this.folder = new ReflectionObjectFolder(INTROSPECTION_ROOT_NAME, (Object)this);
        }
        return this.folder;
    }

    protected AgentJMX createAgentJMX() {
        return new AgentJMX<AbstractAgent>(this);
    }

    public void awaitAgentRunning() {
        try {
            new WaitForFlagChange<2>((Flag<2>)this.getAgentState(), new WaitForFlagChange.IAccept<AgentState>(){

                @Override
                public boolean accept(AgentState flagValue) {
                    return flagValue.getType() == AgentStateType.RUNNING || flagValue.getType() == AgentStateType.FAILED || flagValue.getType() == AgentStateType.END;
                }
            }).await();
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException("Interrupted during wait for the agent to switch to RUNNING", e);
        }
        if (this.getAgentState().getFlag().getType() == AgentStateType.RUNNING) {
            return;
        }
        throw new PogamutRuntimeException("Agent not in the state RUNNING, init failed. AgentState is " + (Object)((Object)this.getAgentState().getFlag().getType()), this);
    }
}

