/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import utils.Matrix;
import utils.VectorDimensionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector
implements Serializable {
    private double[] data;
    private int size = 0;

    public Vector(int size) {
        this.data = new double[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = 0.0;
        }
        this.size = size;
    }

    public Vector(double[] data, int size) {
        this.data = data;
        this.size = size;
    }

    public Vector(int[] data, int size) {
        this.data = new double[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = data[i];
        }
        this.size = size;
    }

    private Vector(List<Double> list) {
        this.size = list.size();
        this.data = new double[this.size];
        int i = 0;
        for (Double d : list) {
            this.data[i++] = d;
        }
    }

    public Vector assign(Vector v2) {
        if (this.size() != v2.size()) {
            throw new VectorDimensionError(this, v2);
        }
        for (int i = 0; i < this.size(); ++i) {
            this.setComponent(i, v2.component(i));
        }
        return this;
    }

    public int size() {
        return this.data.length;
    }

    public double component(int i) {
        return this.data[i];
    }

    public void setComponent(int i, double value) {
        this.data[i] = value;
    }

    public Vector add(Vector v2) throws VectorDimensionError {
        if (this.size() != v2.size()) {
            throw new VectorDimensionError(this, v2);
        }
        Vector result = new Vector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setComponent(i, this.component(i) + v2.component(i));
        }
        return result;
    }

    public static Vector add(Vector v1, Vector v2) {
        return v1.add(v2);
    }

    public Vector subtract(Vector v2) throws VectorDimensionError {
        if (this.size() != v2.size()) {
            throw new VectorDimensionError(this, v2);
        }
        Vector result = new Vector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setComponent(i, this.component(i) - v2.component(i));
        }
        return result;
    }

    public static Vector subtract(Vector v1, Vector v2) {
        return v1.subtract(v2);
    }

    public Vector mult(double a) {
        Vector result = new Vector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setComponent(i, this.component(i) * a);
        }
        return result;
    }

    public static Vector mult(Vector v, double a) {
        return v.mult(a);
    }

    public double dotProduct(Vector v2) throws VectorDimensionError {
        if (this.size() != v2.size()) {
            throw new VectorDimensionError(this, v2);
        }
        double result = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.component(i) * v2.component(i);
        }
        return result;
    }

    public Matrix outerProduct(Vector v2) {
        Matrix result = new Matrix(this.size, v2.size);
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < v2.size; ++j) {
                result.setCell(i, j, this.component(i) * v2.component(j));
            }
        }
        return result;
    }

    public static Matrix outerProduct(Vector v1, Vector v2) {
        return v1.outerProduct(v2);
    }

    public static double dotProduct(Vector v1, Vector v2) {
        return v1.dotProduct(v2);
    }

    public double squared() {
        return this.dotProduct(this);
    }

    public double length() {
        return Math.pow(this.dotProduct(this), 0.5);
    }

    public static Vector normalized(Vector v) {
        return v.mult(1.0 / v.length());
    }

    public static Vector rescaled(Vector v, double newLength) {
        return v.mult(newLength / v.length());
    }

    public Vector reflected(Vector normal) {
        double i_dot_n = this.dotProduct(normal);
        if (i_dot_n > 0.0) {
            return this;
        }
        double scale = -2.0 * i_dot_n / normal.squared();
        return this.add(normal.mult(scale));
    }

    public double radiusImpactParam(Vector v, double R) {
        double a = v.squared();
        double b = 2.0 * this.dotProduct(v);
        if (b >= 0.0) {
            return -1.0;
        }
        double c = this.squared() - R * R;
        double det = b * b - 4.0 * a * c;
        if (det > 0.0) {
            double t = (-b - Math.pow(det, 0.5)) / (2.0 * a);
            return t < 0.0 ? -t : t;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.size(); ++i) {
            result = result + this.component(i) + " ";
        }
        return result;
    }

    public static Vector sort(Vector vect) {
        List<Double> list = vect.toList();
        Collections.sort(list);
        return new Vector(list);
    }

    public static void main(String[] args) {
        int i;
        int size = 5;
        int[] values = new int[size];
        int[] values2 = new int[size + 2];
        Random rand = new Random();
        rand.setSeed(System.currentTimeMillis());
        for (i = 0; i < size; ++i) {
            values[i] = rand.nextBoolean() ? 0 : 1;
        }
        for (i = 0; i < size + 2; ++i) {
            values2[i] = rand.nextBoolean() ? 0 : 1;
        }
        Vector v1 = new Vector(values, size);
        Vector v2 = new Vector(values2, size + 2);
        System.out.println("V1:\n" + v1.toString());
        System.out.println("V2:\n" + v2.toString());
        Matrix M = Vector.outerProduct(v1, v2);
        System.out.println("Resulting Matrix:\n" + M);
    }

    private List<Double> toList() {
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            list.add(this.component(i));
        }
        return list;
    }
}

