/*
 * Decompiled with CFR 0.152.
 */
package utils;

public final class SigmoidFunction {
    private static double lambda = 0.75;

    public static double getSigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-SigmoidFunction.getLambda() * x));
    }

    public static double getInverseSigmoid(double x) {
        if (x == 0.0) {
            return 0.5;
        }
        return -Math.log((1.0 - x) / x) / SigmoidFunction.getLambda();
    }

    public static void main(String[] args) {
        System.out.println("Sigmoid test");
        for (int i = -10; i < 30; ++i) {
            System.out.print((double)i / 10.0 + ": " + SigmoidFunction.getSigmoid((double)i / 10.0) + "\t" + "inversion: " + SigmoidFunction.getInverseSigmoid(SigmoidFunction.getSigmoid((double)i / 10.0)) + "\n");
        }
        System.out.println("Other test cases:");
        double l = -3.0;
        System.out.print(l + ": " + SigmoidFunction.getSigmoid(l) + "\t" + "inversion: " + SigmoidFunction.getInverseSigmoid(SigmoidFunction.getSigmoid(l)) + "\n");
        System.out.println("for close to zero: " + SigmoidFunction.getInverseSigmoid(0.50001));
    }

    public static double getLambda() {
        return lambda;
    }

    public static void setLambda(double aLambda) {
        lambda = aLambda;
    }
}

