/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.Serializable;
import java.util.Random;
import utils.FunctionType;
import utils.MatrixDimensionError;
import utils.Vector;

public class Matrix
implements Serializable {
    private double[][] data;

    public Matrix(int dimension) {
        this.data = new double[dimension][dimension];
        for (int i = 0; i < dimension; ++i) {
            for (int j = 0; j < dimension; ++j) {
                this.data[i][j] = i == j ? 1 : 0;
            }
        }
    }

    public Matrix(int rows, int cols, boolean randomize) {
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        this.data = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data[i][j] = randomize ? random.nextDouble() / 4.0 : 0.0;
            }
        }
    }

    private Matrix(double[][] data) {
        this.data = data;
    }

    public Matrix(int rows, int cols) {
        this.data = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data[i][j] = 0.0;
            }
        }
    }

    public Matrix(Matrix M) {
        this.data = new double[M.rows()][M.cols()];
        this.copy(M);
    }

    public void copy(Matrix M) throws MatrixDimensionError {
        if (M.rows() != this.rows() || M.cols() != this.cols()) {
            throw new MatrixDimensionError(this, M);
        }
        this.subcopy(M);
    }

    public double countCells() {
        double result = 0.0;
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                result += this.cell(i, j);
            }
        }
        return result;
    }

    public void rowMult(int i, double modifCoef) {
        for (int j = 0; j < this.cols(); ++j) {
            this.setCell(i, j, modifCoef * this.cell(i, j));
        }
    }

    public void setCol(int j, Vector col) {
        for (int i = 0; i < this.rows(); ++i) {
            this.setCell(i, j, col.component(i));
        }
    }

    public void subcopy(Matrix M) throws MatrixDimensionError {
        for (int i = 0; i < M.rows(); ++i) {
            for (int j = 0; j < M.cols(); ++j) {
                this.setCell(i, j, M.cell(i, j));
            }
        }
    }

    public int cols() {
        return this.data.length > 0 ? this.data[0].length : 0;
    }

    public int rows() {
        return this.data.length;
    }

    public double cell(int i, int j, FunctionType type) {
        return type.f(this.data[i][j]);
    }

    public double cell(int i, int j) {
        return this.data[i][j];
    }

    public void setCell(int i, int j, double value, FunctionType type) {
        this.data[i][j] = type.f(value);
    }

    public void setCell(int i, int j, double value) {
        this.data[i][j] = value;
    }

    public Matrix add(Matrix M2) throws MatrixDimensionError {
        if (this.rows() != M2.rows() || this.cols() != M2.cols()) {
            throw new MatrixDimensionError(this, M2);
        }
        Matrix result = new Matrix(this.rows(), this.cols());
        for (int j = 0; j < this.cols(); ++j) {
            for (int i = 0; i < this.rows(); ++i) {
                result.setCell(i, j, this.cell(i, j) + M2.cell(i, j));
            }
        }
        return result;
    }

    public static Matrix add(Matrix M1, Matrix M2) throws MatrixDimensionError {
        return M1.add(M2);
    }

    public Matrix addWithAFunction(Matrix M2, FunctionType typeIn, FunctionType typeOut) throws MatrixDimensionError {
        if (this.rows() != M2.rows() || this.cols() != M2.cols()) {
            throw new MatrixDimensionError(this, M2);
        }
        Matrix result = new Matrix(this.rows(), this.cols());
        double temp = 0.0;
        for (int j = 0; j < this.cols(); ++j) {
            for (int i = 0; i < this.rows(); ++i) {
                temp = this.cell(i, j, typeOut) + M2.cell(i, j);
                result.setCell(i, j, temp, typeIn);
            }
        }
        return result;
    }

    public static Matrix addWithAFunction(Matrix M1, Matrix M2, FunctionType typeIn, FunctionType typeOut) throws MatrixDimensionError {
        return M1.addWithAFunction(M2, typeIn, typeOut);
    }

    public Matrix subtract(Matrix M2) throws MatrixDimensionError {
        if (this.rows() != M2.rows() || this.cols() != M2.cols()) {
            throw new MatrixDimensionError(this, M2);
        }
        Matrix result = new Matrix(this.rows(), this.cols());
        for (int j = 0; j < this.cols(); ++j) {
            for (int i = 0; i < this.rows(); ++i) {
                result.setCell(i, j, this.cell(i, j) - M2.cell(i, j));
            }
        }
        return result;
    }

    public static Matrix subtract(Matrix M1, Matrix M2) throws MatrixDimensionError {
        return M1.subtract(M2);
    }

    public Matrix mult(double a) {
        Matrix result = new Matrix(this.rows(), this.cols());
        result.copy(this);
        result.selfMult(a);
        return result;
    }

    public void selfMult(double a) {
        for (int j = 0; j < this.cols(); ++j) {
            for (int i = 0; i < this.rows(); ++i) {
                double[] dArray = this.data[i];
                int n = j;
                dArray[n] = dArray[n] * a;
            }
        }
    }

    public static Vector mult(Matrix M1, Vector v2) throws MatrixDimensionError {
        if (M1.cols() != v2.size()) {
            throw new MatrixDimensionError(M1, v2);
        }
        Vector result = new Vector(M1.rows());
        for (int i = 0; i < M1.rows(); ++i) {
            double tmp = 0.0;
            for (int j = 0; j < M1.cols(); ++j) {
                tmp += M1.cell(i, j) * v2.component(j);
            }
            result.setComponent(i, tmp);
        }
        return result;
    }

    public static Vector mult(Vector v1, Matrix M2) throws MatrixDimensionError {
        if (v1.size() != M2.rows()) {
            throw new MatrixDimensionError(v1, M2);
        }
        Vector result = new Vector(M2.cols());
        for (int j = 0; j < M2.cols(); ++j) {
            double tmp = 0.0;
            for (int i = 0; i < M2.rows(); ++i) {
                tmp += M2.cell(i, j) * v1.component(i);
            }
            result.setComponent(j, tmp);
        }
        return result;
    }

    public Matrix mult(Matrix M2) throws MatrixDimensionError {
        if (this.cols() != M2.rows()) {
            throw new MatrixDimensionError(this, M2);
        }
        Matrix result = new Matrix(this.rows(), M2.cols());
        for (int i = 0; i < result.rows(); ++i) {
            for (int j = 0; j < result.cols(); ++j) {
                double tmp = 0.0;
                for (int k = 0; k < this.cols(); ++k) {
                    tmp += this.cell(i, k) * M2.cell(k, j);
                }
                result.setCell(i, j, tmp);
            }
        }
        return result;
    }

    public static Matrix mult(Matrix M1, Matrix M2) throws MatrixDimensionError {
        return M1.mult(M2);
    }

    public static Matrix mult(Matrix M1, double alpha) {
        return M1.mult(alpha);
    }

    public Matrix inverse() {
        Matrix inv = new Matrix(this.rows());
        return inv.inverse(this);
    }

    public Matrix inverse(Matrix original) {
        if (original.rows() < 1 || original.rows() != original.cols() || this.rows() != original.rows() || this.rows() != this.cols()) {
            return this;
        }
        int n = this.rows();
        this.copy(new Matrix(n));
        if (this.rows() == 1) {
            this.setCell(0, 0, 1.0 / original.cell(0, 0));
            return this;
        }
        Matrix b = new Matrix(original);
        for (int i = 0; i < n; ++i) {
            double mag2;
            int j;
            double mag = 0.0;
            int pivot = -1;
            for (j = i; j < n; ++j) {
                mag2 = Math.abs(b.cell(j, i));
                if (!(mag2 > mag)) continue;
                mag = mag2;
                pivot = j;
            }
            if (pivot == -1 || mag == 0.0) {
                return this;
            }
            if (pivot != i) {
                int j2;
                for (j2 = i; j2 < n; ++j2) {
                    double temp = b.cell(i, j2);
                    this.setCell(i, j2, b.cell(pivot, j2));
                    b.setCell(pivot, j2, temp);
                }
                for (j2 = 0; j2 < n; ++j2) {
                    double temp = this.cell(i, j2);
                    this.setCell(i, j2, this.cell(pivot, j2));
                    this.setCell(pivot, j2, temp);
                }
            }
            mag = b.cell(i, i);
            for (j = i; j < n; ++j) {
                b.setCell(i, j, b.cell(i, j) / mag);
            }
            for (j = 0; j < n; ++j) {
                this.setCell(i, j, this.cell(i, j) / mag);
            }
            for (int k = 0; k < n; ++k) {
                int j3;
                if (k == i) continue;
                mag2 = b.cell(k, i);
                for (j3 = i; j3 < n; ++j3) {
                    b.setCell(k, j3, b.cell(k, j3) - mag2 * b.cell(i, j3));
                }
                for (j3 = 0; j3 < n; ++j3) {
                    this.setCell(k, j3, this.cell(k, j3) - mag2 * this.cell(i, j3));
                }
            }
        }
        return this;
    }

    public Vector getCol(int i) {
        if (i > this.cols() - 1) {
            throw new IllegalArgumentException("invalid index of a column");
        }
        Vector result = new Vector(this.rows());
        for (int j = 0; j < this.rows(); ++j) {
            result.setComponent(j, this.data[j][i]);
        }
        return result;
    }

    public Vector getRow(int i) {
        if (i > this.rows() - 1) {
            throw new IllegalArgumentException("invalid index of a row");
        }
        return new Vector(this.data[i], this.cols());
    }

    public static void main(String[] args) {
        int i;
        int j = 0;
        int m = 4;
        int n = 3;
        int k = 2;
        Matrix m1 = new Matrix(m, k);
        Matrix m2 = new Matrix(k, n);
        for (i = 0; i < m; ++i) {
            for (j = 0; j < k; ++j) {
                m1.setCell(i, j, i);
            }
        }
        for (i = 0; i < k; ++i) {
            for (j = 0; j < n; ++j) {
                m2.setCell(i, j, j);
            }
        }
        Vector vect = new Vector(3);
        vect.setComponent(0, 2.0);
        vect.setComponent(1, 3.0);
        vect.setComponent(2, 2.0);
        System.out.println("Matrix 1: \n" + m1);
        System.out.println("Matrix 2: \n" + m2);
        m1 = Matrix.mult(m1, m2);
        System.out.println("Result of matrix multiplication: \n" + m1);
        vect = Matrix.mult(m1, vect);
        System.out.println("Vector multiplication: " + vect);
        m1.selfMult(3.5);
        m1 = Matrix.add(m1, m1);
        System.out.println("Result of matrix self multiplication and addition: \n" + m1 + "\n cell count: " + m1.countCells());
        m1 = Matrix.addWithAFunction(m1, m1, FunctionType.SIGMOID, FunctionType.INVERSE_SIGMOID);
        System.out.println("Result of limited addition: \n" + m1 + "\n cell count: " + m1.countCells());
        m1.setCol(1, new Vector(m1.rows()));
        System.out.println("Result of added column of zeros: \n" + m1);
    }

    public String toString() {
        String result = "rows: " + this.rows() + "\t cols: " + this.cols() + "\n";
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                result = result + this.cell(i, j) + " ";
            }
            result = result + "\n";
        }
        return result;
    }
}

