/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;

public final class GraphicUtils {
    private static DecimalFormat format = new DecimalFormat();

    public static void saveComponentAsJPEG(Component myComponent, String filename) {
        Dimension size = myComponent.getSize();
        BufferedImage myImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = myImage.createGraphics();
        myComponent.paint(g2);
        try {
            FileOutputStream out = new FileOutputStream(filename + ".jpg");
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode(myImage);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void drawThickLine(Graphics g, int x1, int y1, int x2, int y2, int thickness, Color c) {
        int i;
        int diff = 0;
        if (thickness == 0) {
            return;
        }
        if (thickness == 1) {
            g.setColor(c.brighter());
            g.drawLine(x1, y1, x2, y2);
            return;
        }
        if (thickness == 2) {
            g.setColor(c);
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x1 + 1, y1, x2 + 1, y2);
            return;
        }
        diff = 1;
        g.setColor(c.darker());
        for (i = 0; i < (thickness - 1) / 2; ++i) {
            g.drawLine(x1 + diff, y1, x2 + diff, y2);
        }
        g.drawLine(x1, y1, x2, y2);
        diff = -1;
        for (i = 0; i < thickness / 2; ++i) {
            g.drawLine(x1 + diff, y1, x2 + diff, y2);
        }
    }

    public static String formatDouble(double number) {
        format.setMaximumFractionDigits(2);
        return format.format(number);
    }

    public static void drawLabel(Graphics2D g, String name, double rotation, Point place) {
        if (rotation > Math.PI * 2) {
            rotation /= Math.PI * 2;
        }
        int translationX = 0;
        int translationY = 0;
        if (rotation < 2.0943951023931953) {
            translationX = 3;
            translationY = 4;
        } else if (rotation < Math.PI) {
            translationX = 5;
            translationY = 7;
        } else {
            translationX = -3;
            translationY = -7;
        }
        int x = place.x;
        int y = place.y;
        g.translate(x + translationX, y - translationY);
        g.rotate(-rotation);
        g.drawString(name, 0, 0);
        g.rotate(rotation);
        g.translate(-x - translationX, -y + translationY);
    }
}

