/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public final class FileSaveLoadUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveObject(Object obj, String file, Logger log) {
        ObjectOutputStream s = null;
        try {
            FileOutputStream f = new FileOutputStream(file);
            s = new ObjectOutputStream(f);
            s.writeObject(obj);
            s.flush();
        }
        catch (IOException ex) {
            log.severe("Exception occured while saving: " + ex);
        }
        finally {
            try {
                s.close();
            }
            catch (IOException ex) {
                log.severe("Exception occured while saving: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadObject(String file, Logger log) {
        ObjectInputStream s = null;
        try {
            FileInputStream in = new FileInputStream(file);
            s = new ObjectInputStream(in);
            Object object = s.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            log.severe("Exception occured while loading: " + ex);
        }
        catch (IOException ex) {
            log.severe("Exception occured while loading: " + ex);
        }
        finally {
            try {
                s.close();
            }
            catch (IOException ex) {
                log.severe("Exception occured while loading: " + ex);
            }
        }
        return null;
    }

    public static String fileCounterPrefix(String path, int dayCounter, int hourCounter) {
        String result = path + "_";
        String day = Integer.toString(dayCounter);
        for (int i = 2; i > day.length(); --i) {
            result = result + "0";
        }
        result = result + day + "_";
        String hour = Integer.toString(hourCounter);
        for (int i = 2; i > hour.length(); --i) {
            result = result + "0";
        }
        result = result + hour;
        return result;
    }

    public static String setPathFromDialog(String dialogName, String directory) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        JFileChooser fc = new JFileChooser(dialogName);
        fc.setDialogTitle(dialogName);
        fc.setCurrentDirectory(new File(directory));
        fc.showOpenDialog(frame);
        if (fc.getSelectedFile() == null) {
            return null;
        }
        return fc.getSelectedFile().getAbsolutePath();
    }
}

