/*
 * Decompiled with CFR 0.152.
 */
package scheduler;

import decisionMakingSystem.Action;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.Intention;
import decisionMakingSystem.IntentionStates;
import decisionMakingSystem.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;
import scheduler.DefaultProbability;
import scheduler.IState;
import scheduler.State;
import utils.Interval;
import utils.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbabilisticScheduler
extends Scheduler {
    private ArrayList<Intention> previousPlannedIntentions = new ArrayList();
    private ArrayList<Intention> currentPlannedIntentions = new ArrayList();
    private Intention previousPlannedIntention = null;
    private DefaultProbability transitions = null;

    public ProbabilisticScheduler(ArrayList<Intention> intentions, Logger log, String directory, String planningFilename) {
        this.allIntentions = intentions;
        this.nameToIntention = new HashMap();
        for (Intention intention : intentions) {
            this.nameToIntention.put(intention.getName(), intention);
        }
        this.log = log;
        this.freePartsOfTheDay = new ArrayList();
        this.freeTime = new ArrayList();
        this.daySchedule = new ArrayList();
        this.rnd = new Random(System.currentTimeMillis());
        this.transitions = new DefaultProbability(directory, planningFilename);
    }

    @Override
    public ArrayList<Intention> scheduleNewDay(int counter) {
        for (Intention intention : this.nameToIntention.values()) {
            intention.setActivationIntervals(null);
        }
        Intention lastPreviousIntention = null;
        if (!this.previousPlannedIntentions.isEmpty()) {
            lastPreviousIntention = this.previousPlannedIntentions.get(this.previousPlannedIntentions.size() - 1);
        } else {
            lastPreviousIntention = new Intention();
            lastPreviousIntention.setName("ISleep");
            ArrayList<Interval> newIntervals = new ArrayList<Interval>();
            newIntervals.add(new Interval(0, counter, 0));
            lastPreviousIntention.setActivationIntervals(newIntervals);
        }
        this.currentPlannedIntentions = new ArrayList();
        this.scheduleBasicActions(counter);
        this.previousPlannedIntentions = this.currentPlannedIntentions;
        return this.currentPlannedIntentions;
    }

    public ArrayList<Intention> scheduleNewIntention(int counter) {
        if (this.previousPlannedIntention == null) {
            this.previousPlannedIntention = new Intention();
            this.previousPlannedIntention.setName("Default");
            ArrayList<Interval> newIntervals = new ArrayList<Interval>();
            newIntervals.add(new Interval(0, counter, 0));
            this.previousPlannedIntention.setActivationIntervals(newIntervals);
        }
        IState nextState = this.transitions.computeNextState(TimeUtils.counterToHours(counter), new State(this.previousPlannedIntention.getName()));
        Intention intent = (Intention)this.nameToIntention.get(nextState.getItention());
        intent.setActivationIntervals(new ArrayList<Interval>());
        intent.getActivationIntervals().add(new Interval(counter - 1, counter + TimeUtils.minutesToTicksOfLogic(60.0), this.getActivation(intent)));
        intent.setDuration(TimeUtils.minutesToTicksOfLogic(60.0));
        intent.setEnabled(true);
        if (!this.currentPlannedIntentions.contains(intent)) {
            this.currentPlannedIntentions.add(intent);
        }
        this.previousPlannedIntention = intent;
        return this.currentPlannedIntentions;
    }

    private void scheduleBasicActions(int start) {
        int dayBegins = start - (int)Math.floor(start % GlobalParameters.LENGHT_OF_A_DAY);
        int dayEnds = dayBegins + GlobalParameters.LENGHT_OF_A_DAY;
        int wakeUpTime = (int)Math.round((double)GlobalParameters.LENGHT_OF_A_DAY / 3.3);
        Intention greet = (Intention)this.nameToIntention.get("ISayHello");
        Intention eat = (Intention)this.nameToIntention.get("IEat");
        Intention hygiene = (Intention)this.nameToIntention.get("IHygiene");
        ArrayList<Interval> activationIntervals = new ArrayList<Interval>();
        activationIntervals.add(new Interval(dayBegins, dayEnds, 30));
        greet.setActivationIntervals(activationIntervals);
        activationIntervals = new ArrayList();
        int randNumber = this.rnd.nextInt(40);
        activationIntervals.add(new Interval(dayBegins + wakeUpTime + TimeUtils.minutesToTicksOfLogic(5 + randNumber), dayBegins + wakeUpTime + TimeUtils.minutesToTicksOfLogic(20 + randNumber), 80));
        randNumber = this.rnd.nextInt(40);
        activationIntervals.add(new Interval(dayEnds - TimeUtils.minutesToTicksOfLogic(45 + randNumber), dayEnds - TimeUtils.minutesToTicksOfLogic(30 + randNumber), 80));
        hygiene.setActivationIntervals(activationIntervals);
        activationIntervals = new ArrayList();
        randNumber = this.rnd.nextInt(40);
        activationIntervals.add(new Interval(dayBegins + wakeUpTime + TimeUtils.minutesToTicksOfLogic(20 + randNumber), dayBegins + wakeUpTime + TimeUtils.minutesToTicksOfLogic(40 + randNumber), 80));
        int timeOfLunch = dayBegins + GlobalParameters.LENGHT_OF_A_DAY / 2 + TimeUtils.minutesToTicksOfLogic(this.rnd.nextInt(60) - 30);
        activationIntervals.add(new Interval(timeOfLunch, timeOfLunch + TimeUtils.minutesToTicksOfLogic(40.0), 60));
        int timeOfDinner = dayBegins + GlobalParameters.LENGHT_OF_A_DAY / 2 + GlobalParameters.LENGHT_OF_A_DAY / 4 + TimeUtils.minutesToTicksOfLogic(this.rnd.nextInt(60) - 90);
        activationIntervals.add(new Interval(timeOfDinner, timeOfDinner + TimeUtils.minutesToTicksOfLogic(40.0), 80));
        eat.setActivationIntervals(activationIntervals);
        this.currentPlannedIntentions.add(eat);
        this.currentPlannedIntentions.add(hygiene);
    }

    public Intention createIntention(ArrayList<Interval> intervals, int activity, int duration, IState state) {
        Intention result = new Intention();
        result.setActivationIntervals(intervals);
        result.setActivity(activity);
        result.setDuration(duration);
        result.setMemoryDuration(300);
        result.setRealized(IntentionStates.NO);
        result.setActions(new ArrayList<Action>());
        result.setName(state.getItention());
        return result;
    }

    @Override
    public void changeLifestyle(String directory, String planningFilename, int alarm) {
    }

    private int getActivation(Intention intent) {
        if (intent.getName().contains("Work")) {
            return 70;
        }
        if (intent.getName().contains("Sleep")) {
            return 50;
        }
        return 60;
    }
}

