/*
 * Decompiled with CFR 0.152.
 */
package scheduler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import scheduler.IState;
import scheduler.ProbabilisticSchedulerEntry;
import scheduler.ProbabilisticSchedulerEntryListWrapper;
import scheduler.ProbabilisticSchedulerTransitionEntry;
import scheduler.ProbabilityDistribution;
import scheduler.SInterval;
import scheduler.State;
import scheduler.StateTransition;
import utils.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProbability
implements ProbabilityDistribution {
    Random random = new Random();
    Map<IState, List<SInterval>> stateIntervalTable = null;

    @Override
    public Map<IState, Double> getStateTransitionsProbabilities(double time, IState previousState) {
        HashMap<IState, Double> resultMap = new HashMap<IState, Double>();
        if (this.stateIntervalTable.get(previousState) != null) {
            for (SInterval interval : this.stateIntervalTable.get(previousState)) {
                if (!interval.isApplicable(time)) continue;
                for (StateTransition sTran : interval.getTransitions()) {
                    resultMap.put(sTran.getTargetState(), sTran.getProbability());
                }
            }
        }
        return resultMap;
    }

    @Override
    public IState computeNextState(double time, IState previousState) {
        Map<IState, Double> transitionProbabilities = this.getStateTransitionsProbabilities(time, previousState);
        double randomValue = this.random.nextDouble();
        double currentValue = 0.0;
        for (IState state : transitionProbabilities.keySet()) {
            if (!(randomValue <= (currentValue += transitionProbabilities.get(state).doubleValue()))) continue;
            return state;
        }
        if (!previousState.getItention().equals("Default")) {
            return this.computeNextState(time, new State("Default"));
        }
        throw new RuntimeException("Transition not defined!");
    }

    public void addStateTransition(int from, int to, IState fromState, IState toState, double probability) {
        StateTransition stateTrans;
        List<SInterval> stateIntervals = this.stateIntervalTable.get(fromState);
        if (stateIntervals == null) {
            stateIntervals = new ArrayList<SInterval>();
            this.stateIntervalTable.put(fromState, stateIntervals);
        }
        SInterval intervalToAddTo = null;
        for (SInterval interv : stateIntervals) {
            if (interv.getFrom() != from || interv.getTo() != to) continue;
            intervalToAddTo = interv;
            break;
        }
        if (intervalToAddTo != null) {
            for (StateTransition sTran : intervalToAddTo.getTransitions()) {
                if (!sTran.getTargetState().getItention().equals(toState.getItention())) continue;
                throw new RuntimeException("State transition already there!");
            }
            stateTrans = new StateTransition(new State(toState.getItention()), probability);
            intervalToAddTo.getTransitions().add(stateTrans);
        } else {
            stateTrans = new StateTransition(new State(toState.getItention()), probability);
            ArrayList<StateTransition> newStateTransitionList = new ArrayList<StateTransition>();
            newStateTransitionList.add(stateTrans);
            intervalToAddTo = new SInterval(newStateTransitionList, from, to);
            stateIntervals.add(intervalToAddTo);
        }
    }

    public void setExampleTransitions() {
        this.stateIntervalTable = new HashMap<IState, List<SInterval>>();
        this.random.setSeed(TimeUtils.getTimeInMilis());
        this.addStateTransition(7, 20, new State("ISleep"), new State("IWork"), 1.0);
        this.addStateTransition(7, 20, new State("IWork"), new State("IWork"), 0.5);
        this.addStateTransition(7, 20, new State("IWork"), new State("IEntertainment"), 0.5);
        this.addStateTransition(7, 20, new State("IEntertainment"), new State("IEntertainment"), 0.5);
        this.addStateTransition(7, 20, new State("Default"), new State("IWork"), 1.0);
        this.addStateTransition(20, 22, new State("Default"), new State("IEntertainment"), 1.0);
        this.addStateTransition(20, 22, new State("IWork"), new State("IStudy"), 0.8);
        this.addStateTransition(20, 22, new State("IWork"), new State("IEntertainment"), 0.2);
        this.addStateTransition(20, 22, new State("IStudy"), new State("IStudy"), 0.8);
        this.addStateTransition(20, 22, new State("IStudy"), new State("IEntertainment"), 0.2);
        this.addStateTransition(22, 24, new State("Default"), new State("IGoToPub"), 1.0);
        this.addStateTransition(0, 7, new State("ISleep"), new State("ISleep"), 1.0);
        this.addStateTransition(0, 7, new State("Default"), new State("ISleep"), 1.0);
    }

    public DefaultProbability(Map<IState, List<SInterval>> stateIntervalTable) {
        this.stateIntervalTable = stateIntervalTable;
        this.random.setSeed(TimeUtils.getTimeInMilis());
    }

    public DefaultProbability(String directory, String planningFilename) {
        this.stateIntervalTable = new HashMap<IState, List<SInterval>>();
        this.random.setSeed(TimeUtils.getTimeInMilis());
        ArrayList<ProbabilisticSchedulerEntry> schedulerEntries = this.loadTransitionEntries(directory, planningFilename);
        for (ProbabilisticSchedulerEntry entry : schedulerEntries) {
            for (ProbabilisticSchedulerTransitionEntry transitionEntry : entry.transitions) {
                this.addStateTransition(entry.from, entry.to, new State(transitionEntry.fromIntention), new State(transitionEntry.toIntention), transitionEntry.probability);
            }
        }
    }

    private ArrayList<ProbabilisticSchedulerEntry> loadTransitionEntries(String directory, String filename) {
        File file = new File(directory + filename);
        ProbabilisticSchedulerEntryListWrapper wrapper = null;
        try {
            FileInputStream reader = new FileInputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProbabilisticSchedulerEntryListWrapper.class});
            Unmarshaller u = context.createUnmarshaller();
            wrapper = (ProbabilisticSchedulerEntryListWrapper)u.unmarshal((InputStream)reader);
        }
        catch (Exception e) {
            System.err.println("Error in loading " + filename + "\n" + e);
        }
        return wrapper.list;
    }

    public IState computeNextState(double counter, String name) {
        return this.computeNextState(counter, new State(name));
    }
}

