/*
 * Decompiled with CFR 0.152.
 */
package episodicbot;

import cz.cuni.amis.pogamut.base.agent.AbstractGhostAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
import cz.cuni.amis.pogamut.base.agent.navigation.PathPlannerListener;
import cz.cuni.amis.pogamut.base.communication.commands.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTAstar;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004SyncLockableWorldView;
import episodicbot.EpisBot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFinderModule {
    AbstractGhostAgent.AgentAct act;
    UT2004SyncLockableWorldView worldView;
    AgentInfo agentInfo;
    public UTAstar myPathPlanner;
    public HashMap<UnrealId, NavPoint> knownNavPoints = new HashMap();
    public ArrayList<ILocated> myPath = new ArrayList();
    public boolean pathRequested = false;
    public boolean pathReceived = false;
    public double pathRequestedTime = 0.0;
    public int pathRerequestDelay = 3;
    public Location nearestNavLocation;
    public double lastJumpTime = 0.0;
    public double jumpDelay = 10.0;
    public Location lastFollowPathLocation;
    public double currentTime;
    private final Logger log;
    private ArrayList<Item> itemsToRunAround = new ArrayList();
    private int currentIndexOfItem;
    static double approachRadius = 150.0;
    IWorldEventListener<MapPointListObtained> myMapListObtainedListener = new IWorldEventListener<MapPointListObtained>(){

        @Override
        public void notify(MapPointListObtained event) {
            MapPointListObtained map = event;
            PathFinderModule.this.knownNavPoints.putAll(map.getNavPoints());
        }
    };
    public IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>(){

        @Override
        public void notify(BeginMessage bm) {
            PathFinderModule.this.currentTime = bm.getTime();
        }
    };
    public PathPlannerListener myPathListener = new PathPlannerListener(){

        public void pathEvent(List path) {
            PathFinderModule.this.myPath = (ArrayList)path;
            PathFinderModule.this.pathReceived = true;
        }
    };

    protected Location getNearestNavLocation(Location targetLocation) {
        NavPoint result = null;
        for (NavPoint nav : this.knownNavPoints.values()) {
            if (result == null) {
                result = nav;
                continue;
            }
            if (!(nav.getLocation().getDistance(targetLocation) < result.getLocation().getDistance(targetLocation))) continue;
            result = nav;
        }
        return result.getLocation();
    }

    public boolean runAroundItemsInTheMap(ArrayList<Item> newItemsToRunAround) {
        if (newItemsToRunAround == null || newItemsToRunAround.isEmpty()) {
            return false;
        }
        if (this.itemsToRunAround.isEmpty()) {
            this.itemsToRunAround.addAll(newItemsToRunAround);
            this.currentIndexOfItem = 0;
        } else if (!this.itemsToRunAround.equals(newItemsToRunAround)) {
            this.itemsToRunAround.clear();
            this.itemsToRunAround.addAll(newItemsToRunAround);
            this.currentIndexOfItem = 0;
        }
        if (this.currentIndexOfItem >= this.itemsToRunAround.size()) {
            this.currentIndexOfItem = 0;
        }
        if (this.agentInfo.atLocation(this.itemsToRunAround.get(this.currentIndexOfItem).getLocation(), approachRadius)) {
            ++this.currentIndexOfItem;
            if (this.currentIndexOfItem >= this.itemsToRunAround.size()) {
                this.currentIndexOfItem = 0;
            }
        }
        this.goToLocation(this.itemsToRunAround.get(this.currentIndexOfItem).getLocation());
        return true;
    }

    public boolean goToLocation(Location targetLocation) {
        Iterator<ILocated> it;
        Location temp = null;
        if (this.agentInfo.atLocation(targetLocation, 50.0)) {
            this.nearestNavLocation = null;
            this.lastFollowPathLocation = null;
            this.myPath.clear();
            this.pathReceived = false;
            this.pathRequested = false;
            return false;
        }
        if (this.myPath.isEmpty() && !this.pathRequested) {
            this.nearestNavLocation = this.getNearestNavLocation(targetLocation);
            this.lastFollowPathLocation = this.agentInfo.getLocation();
            try {
                this.myPathPlanner.addPathListener(this.myPathListener);
                this.pathRequestedTime = this.currentTime;
                this.myPathPlanner.computePath(this.agentInfo.getLocation(), this.nearestNavLocation);
                this.pathRequested = true;
                return true;
            }
            catch (PathNotConstructable ex) {
                this.log.log(Level.SEVERE, null, ex);
                return false;
            }
        }
        if (this.pathRequested && ((temp = this.getNearestNavLocation(targetLocation)).getDistance(this.nearestNavLocation) > 80.0 || this.agentInfo.getLocation().getDistance(this.lastFollowPathLocation) > 250.0)) {
            this.nearestNavLocation = temp;
            this.lastFollowPathLocation = this.agentInfo.getLocation();
            this.myPath.clear();
            this.pathReceived = false;
            try {
                this.pathRequestedTime = this.currentTime;
                this.myPathPlanner.computePath(this.agentInfo.getLocation(), this.nearestNavLocation);
            }
            catch (PathNotConstructable ex) {
                this.log.log(Level.SEVERE, null, ex);
                return false;
            }
        }
        if (this.pathRequested && !this.pathReceived) {
            if (this.currentTime - this.pathRequestedTime > (double)this.pathRerequestDelay) {
                this.nearestNavLocation = this.getNearestNavLocation(targetLocation);
                this.lastFollowPathLocation = this.agentInfo.getLocation();
                try {
                    this.pathRequestedTime = this.currentTime;
                    this.myPathPlanner.computePath(this.agentInfo.getLocation(), this.nearestNavLocation);
                    this.pathRequested = true;
                    return true;
                }
                catch (PathNotConstructable ex) {
                    Logger.getLogger(EpisBot.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
            return true;
        }
        if (this.myPath.isEmpty() && this.pathReceived) {
            if (this.agentInfo.atLocation(targetLocation, 250.0)) {
                this.myPath.add(targetLocation);
            } else {
                this.pathRequested = false;
                this.pathReceived = false;
                return true;
            }
        }
        if (this.myPath.get(0).getLocation().getDistance(this.agentInfo.getLocation()) < 35.0) {
            this.myPath.remove(0);
        }
        if ((it = this.myPath.iterator()).hasNext()) {
            Location l1 = it.next().getLocation();
            this.lastFollowPathLocation = this.agentInfo.getLocation();
            if (it.hasNext()) {
                Location l2 = it.next().getLocation();
                this.getAct().act(new Move().setFirstLocation(l1).setSecondLocation(l2));
                this.handleBotStuck();
                return true;
            }
            this.getAct().act(new Move().setFirstLocation(l1));
            this.handleBotStuck();
            return true;
        }
        return false;
    }

    PathFinderModule(EpisBot agent) {
        this.act = agent.getAct();
        this.worldView = (UT2004SyncLockableWorldView)agent.getWorldView();
        this.agentInfo = agent.agentInfo;
        this.log = agent.getLogger().user();
        this.initialize();
    }

    private IAct getAct() {
        return this.act;
    }

    private void initialize() {
        this.myPathPlanner = new UTAstar(this.act, this.worldView);
        this.getWorldView().addEventListener(MapPointListObtained.class, this.myMapListObtainedListener);
        this.getWorldView().addEventListener(BeginMessage.class, this.myBegListener);
    }

    private IWorldView getWorldView() {
        return this.worldView;
    }

    private void handleBotStuck() {
        if (this.pathReceived && this.currentTime - this.pathRequestedTime > 5.0 && this.agentInfo.getVelocity().size() < 50.0) {
            if (this.currentTime - this.lastJumpTime > this.jumpDelay) {
                this.getAct().act(new Jump());
                this.lastJumpTime = this.currentTime;
            } else if (this.currentTime - this.lastJumpTime > 3.0) {
                Random rnd = new Random();
                this.getAct().act(new Move().setFirstLocation(this.agentInfo.getLocation().add(new Location((rnd.nextDouble() - 0.5) * 200.0, (rnd.nextDouble() - 0.5) * 200.0, 0.0))));
            }
        }
    }
}

