/*
 * Decompiled with CFR 0.152.
 */
package episodicbot;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.UTGuiceSyncFactory;
import decisionMakingSystem.DMSModuleViewer;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GMTTime;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.ItemMemory;
import episodicbot.DMSMemoryVO;
import episodicbot.ExperimentController;
import episodicbot.ExperimentControllerImpl;
import episodicbot.PathFinderModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import utils.FileSaveLoadUtils;
import utils.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public class EpisBot
extends SyncUT2004Bot<UT2004SyncLockableWorldView> {
    public boolean verbose;
    public double gmtTime = 0.0;
    private double oldGMT = 0.0;
    private boolean loadAgentFromFile = false;
    private ExperimentController expControl;
    private DecisionModuleImpl decisions = null;
    public Game game;
    public AgentInfo agentInfo;
    public Players players;
    private DMSMemoryVO memoryVO = null;
    private DMSModuleViewer dmsViz;
    private ArrayList<Item> knownWeapons = new ArrayList();
    private ArrayList<Item> knownItems = new ArrayList();
    public String mapMarkings = "maps\\UnrealVille.xml";
    String directory = ".\\";
    public String planningFilename = "transitions\\PTravelingSalesman.xml";
    private Initialize initilizeCommand = null;
    public int lifeTime = 0;
    private boolean noFrames = false;
    PathFinderModule myPathFinder;
    public HashMap<UnrealId, NavPoint> knownNavPoints = new HashMap();
    public double currentTime;
    public ItemMemory itemMemory;
    private int currentItemIndex = 0;
    IWorldEventListener<MapPointListObtained> myMapListObtainedListener = new IWorldEventListener<MapPointListObtained>(){

        @Override
        public void notify(MapPointListObtained event) {
            MapPointListObtained map = event;
            EpisBot.this.knownNavPoints.putAll(map.getNavPoints());
            for (NavPoint nav : EpisBot.this.knownNavPoints.values()) {
                EItem eItem = ((EpisBot)EpisBot.this).decisions.things.processItem(nav);
                if (eItem == null) continue;
                EpisBot.this.itemMemory.addItemToMemory(eItem, 0, 1);
            }
        }
    };
    public IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>(){

        @Override
        public void notify(BeginMessage bm) {
            EpisBot.this.currentTime = bm.getTime();
        }
    };

    public static void main(String[] args) throws PogamutException {
        EpisBot.agentCreator(".\\", "maps\\UnrealVille.xml", "transitions\\PTravelingSalesman.xml", new Initialize(), 24);
    }

    public static EpisBot agentCreator(String directory, String mapFile, String planFile, Initialize botInit, int lifeTime) throws PogamutException {
        UTGuiceSyncFactory<SocketConnectionAddress> factory = new UTGuiceSyncFactory<SocketConnectionAddress>(EpisBot.class);
        EpisBot agent = null;
        agent = (EpisBot)factory.newAgent(new SocketConnectionAddress("localhost", 3000));
        agent.getLogger().addConsoleHandlersToAllCategories();
        agent.getLogger().setLevel(Level.INFO);
        agent.mapMarkings = mapFile;
        agent.directory = directory;
        agent.planningFilename = planFile;
        agent.initilizeCommand = botInit;
        agent.lifeTime = lifeTime;
        agent.start();
        return agent;
    }

    @Override
    protected void doLogic() {
        this.expControl.increaseInternalCounter(this.currentTime);
        this.doNormalActions();
        if (GMTTime.isMidnight((int)this.expControl.getInternalCounter())) {
            this.getLogger().user().fine("Midnight update Main.java");
            this.expControl.controlExperiment();
        }
    }

    private void doNormalActions() {
        this.memoryVO = this.decisions.doReasoning(this.getCurrentTime());
        this.memoryVO.setVerbose(this.verbose);
        if (this.oldGMT != this.gmtTime) {
            this.decisions.setGMT(this.gmtTime);
            this.expControl.getDMSLogger().writeAMessage("Time zone changed! Change: " + this.gmtTime + "\n\r");
            this.memoryVO.setGMTChanged(true);
            this.oldGMT = this.gmtTime;
        }
        this.expControl.getDMSLogger().update(this.memoryVO);
        if (!this.noFrames) {
            this.dmsViz.update();
            if (this.memoryVO.getCounter() % (GlobalParameters.LENGHT_OF_A_DAY / 24) == 0) {
                // empty if block
            }
        }
        if (TimeUtils.isHour(this.decisions.counter)) {
            this.expControl.hourUpdate();
        }
    }

    @Override
    protected void prePrepareBot() {
        this.game = new Game((IWorldView)this.getWorldView(), this.getLogger().user());
        this.agentInfo = new AgentInfo((IWorldView)this.getWorldView(), this.game, this.getLogger().user());
        this.players = new Players((IWorldView)this.getWorldView(), this.agentInfo, this.getLogger().user());
        this.itemMemory = new ItemMemory(this.getLogger().user());
        ((UT2004SyncLockableWorldView)this.getWorldView()).addEventListener(MapPointListObtained.class, this.myMapListObtainedListener);
        ((UT2004SyncLockableWorldView)this.getWorldView()).addEventListener(BeginMessage.class, this.myBegListener);
        this.myPathFinder = new PathFinderModule(this);
        boolean loadAnyway = true;
        if (this.loadAgentFromFile) {
            boolean bl = loadAnyway = !this.loadAgentFromFiles();
        }
        if (loadAnyway) {
            this.prepareNewAgent();
        }
        if (!this.noFrames) {
            this.dmsViz = new DMSModuleViewer(this.decisions);
        }
        this.getLogger().user().info("finished with preparation.");
        this.getLogger().platform().setLevel(Level.SEVERE);
        this.getLogger().in().setLevel(Level.SEVERE);
        this.getLogger().out().setLevel(Level.SEVERE);
    }

    private void setNextWeaponTarget() {
        ++this.currentItemIndex;
        if (this.knownWeapons.size() == this.currentItemIndex) {
            this.currentItemIndex = 0;
        }
    }

    private boolean loadAgentFromFiles() {
        String memPath = FileSaveLoadUtils.setPathFromDialog("Memory path", this.directory);
        if (memPath == null) {
            return false;
        }
        try {
            String dmsPath = memPath.substring(0, memPath.length() - 12) + "DMS" + memPath.substring(memPath.length() - 6, memPath.length());
            String expPath = memPath.substring(0, memPath.length() - 12) + "ExpController" + memPath.substring(memPath.length() - 6, memPath.length());
            System.out.println(memPath + " \n" + dmsPath + " \n" + expPath);
            this.decisions = DecisionModuleImpl.loadFromFile(dmsPath, this.getLogger().user(), this, this.directory);
            this.expControl = ExperimentControllerImpl.loadFromFile(expPath, this.getLogger().user(), this);
            this.gmtTime = this.decisions.getGMTTime();
        }
        catch (Exception e) {
            this.getLogger().user().severe("Exception occured while loading agent from a file." + e);
            this.getLogger().user().severe("Fresh instantiating of agent!");
            return false;
        }
        return true;
    }

    private void prepareNewAgent() {
        this.decisions = new DecisionModuleImpl(this.itemMemory);
        this.decisions.prepareLogic(this, this.directory, this.planningFilename);
        this.expControl = new ExperimentControllerImpl(this.getLogger().user(), this.directory, this);
        this.expControl.prepareExperiment();
        this.decisions.setDMSLogger(this.expControl.getDMSLogger());
    }

    @Override
    protected void postPrepareBot(GameInfo gi) {
        this.knownItems.addAll(((UT2004SyncLockableWorldView)this.getWorldView()).getAll(Item.class).values());
        this.knownWeapons.addAll(((UT2004SyncLockableWorldView)this.getWorldView()).getAll(Item.class).values());
        for (Item it : this.knownItems) {
            EItem eItem = this.decisions.things.processItem(it);
            if (eItem == null) continue;
            this.itemMemory.addItemToMemory(eItem, 0, 1);
        }
        Iterator<Item> iterator = this.knownWeapons.iterator();
        while (iterator.hasNext()) {
            Item it;
            it = iterator.next();
            if (it.getType().getCategory() == ItemType.Category.WEAPON) continue;
            iterator.remove();
        }
    }

    protected void shutdownAgent() {
        this.expControl.cleanUp();
        if (!this.noFrames) {
            this.dmsViz.dispose();
        }
    }

    private void runAroundTheMap() {
        this.runAroundItemsInTheMap(this.knownWeapons, false);
    }

    DecisionModuleImpl getDMS() {
        return this.decisions;
    }

    @Override
    protected void botKilled(BotKilled event) {
    }

    @Override
    protected Initialize createInitializeCommand() {
        if (this.initilizeCommand == null) {
            return new Initialize();
        }
        return this.initilizeCommand;
    }

    @Override
    protected void botInitialized(ConfigChange config, InitedMessage init) {
    }

    @Inject
    public EpisBot(AgentLogger logger, UT2004SyncLockableWorldView worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
    }

    public void runAroundItemsInTheMap(ArrayList<Item> itemsToRunAround, boolean b) {
        this.myPathFinder.runAroundItemsInTheMap(itemsToRunAround);
    }

    public ArrayList<Item> getKnownWeapons() {
        return this.knownWeapons;
    }

    public Object getSeeItem(int id) {
        for (Item it : this.knownItems) {
            if (it.getId().getId() != id || !it.isVisible()) continue;
            return it;
        }
        return null;
    }

    public void safeRunToLocation(Location location) {
        this.myPathFinder.goToLocation(location);
    }

    public double getAgentScore() {
        return this.agentInfo.getScore();
    }

    public int getAgentAmmo() {
        Self self = ((UT2004SyncLockableWorldView)this.getWorldView()).getSingle(Self.class);
        return self.getPrimaryAmmo();
    }

    public int getCurrentTime() {
        return (int)Math.round(this.currentTime);
    }
}

