/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import decisionMakingSystem.DayPartProbability;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import utils.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
public class ScheduleEntry
implements Serializable {
    @XmlElement
    private ArrayList<DayPartProbability> executionTimes = null;
    @XmlElement
    private ArrayList<Interval> weeks = null;
    @XmlElement
    public String intention = null;

    public double probabilityOfPerformance(int day, int part, int week) {
        boolean result = false;
        for (Interval interval : this.weeks) {
            if (!interval.isInInterval(week)) continue;
            result = true;
            break;
        }
        if (!result) {
            return 0.0;
        }
        for (DayPartProbability execTime : this.executionTimes) {
            if (!execTime.corresponds(day, part)) continue;
            return execTime.getProbability();
        }
        return 0.0;
    }

    ScheduleEntry(String intention, ArrayList<Interval> weeks, ArrayList<DayPartProbability> executionTimes) {
        this.intention = intention;
        this.weeks = weeks;
        this.executionTimes = executionTimes;
    }

    ScheduleEntry() {
    }

    public String toString() {
        String result = "Intention: " + this.intention;
        result = result + "Execution times: " + this.executionTimes;
        result = result + "Weeks: " + this.weeks;
        return result;
    }

    static ScheduleEntry getExample() {
        ScheduleEntry result = new ScheduleEntry();
        result.intention = "ISleep";
        DayPartProbability temp = new DayPartProbability(4, 2, 0.9);
        result.executionTimes = new ArrayList();
        result.executionTimes.add(temp);
        temp = new DayPartProbability(7, 1, 0.3);
        result.executionTimes.add(temp);
        result.weeks = new ArrayList();
        result.weeks.add(new Interval(2, 5, 0));
        return result;
    }
}

