/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import decisionMakingSystem.Affordance;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.AgentParameters;
import decisionMakingSystem.EItem;
import decisionMakingSystem.ItemCathegory;
import decisionMakingSystem.ItemRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemMemory
implements Serializable {
    private HashMap<AffordanceType, ArrayList<ItemRecord>> itemInfo = new HashMap();
    private transient Logger log;

    public ItemMemory(Logger log) {
        this.log = log;
    }

    public void addItemToMemory(EItem item, int time, int state) {
        ItemRecord newRecord = new ItemRecord(item, time);
        if (item.cathegory.equals((Object)ItemCathegory.INVENTORY)) {
            return;
        }
        for (Affordance aff : item.getAffordances()) {
            if (!this.itemInfo.containsKey((Object)aff.type)) {
                this.itemInfo.put(aff.type, new ArrayList());
            }
            if (!this.itemInfo.get((Object)aff.type).contains(newRecord)) {
                this.itemInfo.get((Object)aff.type).add(0, newRecord);
            } else {
                for (ItemRecord record : this.itemInfo.get((Object)aff.type)) {
                    if (!record.equals(newRecord)) continue;
                    newRecord = record;
                }
            }
            if (state == 0) {
                newRecord.found(time);
            }
            if (state != 1) continue;
            newRecord.seen(time);
        }
    }

    public void dailyReport() {
        String logResult = "Number of stored items: " + this.itemInfo.values().size() + "\n";
        ArrayList<ItemRecord> list = null;
        for (AffordanceType affordance : this.itemInfo.keySet()) {
            logResult = logResult + "List for an affordance: " + (Object)((Object)affordance) + "\n";
            list = this.itemInfo.get((Object)affordance);
            for (ItemRecord record : list) {
                logResult = logResult + record.toString() + " \t";
            }
            logResult = logResult + "\n";
        }
        this.log.config("Daily report from item memory: " + logResult);
    }

    public ArrayList<ItemRecord> getLocationOfAffordances(AffordanceType aff, int counter) {
        ArrayList<ItemRecord> result = new ArrayList<ItemRecord>();
        ItemRecord best = null;
        double max = 0.0;
        if (this.itemInfo == null || this.itemInfo.get((Object)aff) == null) {
            return null;
        }
        String logReport = "Considered records: \n";
        for (ItemRecord record : this.itemInfo.get((Object)aff)) {
            record.updateProbability(counter);
            logReport = logReport + record + " \n";
            if (record.probability > AgentParameters.biasProbability) {
                result.add(record);
            }
            if (!(record.probability > max)) continue;
            max = record.probability;
            best = record;
        }
        this.log.fine(logReport);
        if (result.isEmpty()) {
            result.add(best);
        }
        return result;
    }

    public void oblivion(int counter) {
        for (AffordanceType aff : this.itemInfo.keySet()) {
            int i = 0;
            while (i < this.itemInfo.get((Object)aff).size()) {
                ItemRecord record = this.itemInfo.get((Object)aff).get(i);
                record.dailyUpdate();
                if (record.obsolete(counter)) {
                    this.itemInfo.get((Object)aff).remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    void setLoggerAfterLoad(Logger log) {
        this.log = log;
    }
}

