/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import decisionMakingSystem.Action;
import decisionMakingSystem.Affordance;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.BasicIntentionLoader;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.IntentionStates;
import episodicbot.EpisBot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import utils.DeepCopyCreator;
import utils.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
public class Intention
implements Comparable,
Serializable {
    private int activity = 0;
    private boolean enabled = true;
    private IntentionStates realized = IntentionStates.NO;
    private ArrayList<Action> actions = null;
    private ArrayList<Action> notTriedActions = null;
    private Action chosenAction = null;
    private ArrayList<Interval> activationIntervals = null;
    private Interval dropoutInterval = null;
    private Action ancestorAction = null;
    private String name = null;
    private int timeLimit = 0;
    private int duration = 0;
    private int memoryDuration = 0;
    private int fadeout = GlobalParameters.FADEOUT_FOR_INTENTIONS;
    private static Random rnd = new Random();

    public Intention cloneBySerialize(EpisBot agent, DecisionModuleImpl dModule) {
        Intention result = (Intention)DeepCopyCreator.copy(this);
        ArrayList<Action> actionsWithAtomicActions = BasicIntentionLoader.getActionsWithAtomicActions(result);
        for (Action action : actionsWithAtomicActions) {
            for (AtomicAction aAction : action.atomicActions) {
                aAction.agent = agent;
                aAction.dModule = dModule;
            }
        }
        return result;
    }

    public String toString() {
        String result = "INTENTION: " + this.name + " | ";
        result = result + "Activity: " + this.activity + " | " + "Duration: " + this.duration + " | ";
        result = result + "Enabled: " + this.enabled + " | ";
        result = result + "Memory duration: " + this.memoryDuration + " | " + "Realized: " + (Object)((Object)this.realized) + " | ";
        result = this.ancestorAction != null ? result + "Parent action name: " + this.ancestorAction.name + " | " : result + "Root intention! | ";
        if (this.actions != null && !this.actions.isEmpty()) {
            result = result + "Actions: ";
            for (Action i : this.actions) {
                result = result + i.name + " ";
            }
            result = this.notTriedActions != null ? result + " Not tried: " + this.notTriedActions.size() + " | " : result + " Not tried: " + this.actions.size() + " | ";
        }
        if (this.activationIntervals != null) {
            result = result + " ActivationIntervals: ";
            for (Interval interval : this.activationIntervals) {
                result = result + interval + " ";
            }
        }
        if (this.chosenAction != null) {
            result = result + "Chosen action: " + this.chosenAction.name;
        }
        result = result + " Fadeout: " + this.fadeout;
        return result + "\n";
    }

    public boolean increased(int time) {
        for (Interval interval : this.activationIntervals) {
            if (!interval.isInInterval(time)) continue;
            return true;
        }
        return false;
    }

    public void updateActivity(int time) {
        if (this.dropoutInterval != null && this.dropoutInterval.isInInterval(time)) {
            this.activity = 0;
            return;
        }
        this.dropoutInterval = null;
        this.activity = 0;
        for (Interval i : this.activationIntervals) {
            if (!i.isInInterval(time) || i.valueInTime(time) <= this.activity) continue;
            this.activity = i.valueInTime(time);
        }
    }

    public void increaseActivityToAllSources(ArrayList<EItem> things) {
        for (Action act : this.actions) {
            for (AffordanceType aff : act.satisfyingItems.keySet()) {
                if (act.satisfyingItems.get((Object)aff) == null) continue;
                act.satisfyingItems.get((Object)aff).setAttractivity(this.activity);
            }
        }
        int temp = 0;
        for (EItem it : things) {
            for (Affordance aff : it.getAffordances()) {
                if (aff.attractivity <= temp) continue;
                temp = aff.attractivity;
            }
            it.setAttractivity(temp + it.getBasicAttractivity());
        }
    }

    public Intention rootIntention() {
        Intention result = this;
        boolean go = true;
        while (go && result.ancestorAction != null && result.ancestorAction.intention != null) {
            result = result.ancestorAction.intention;
        }
        return result;
    }

    public boolean isRoot() {
        return this.ancestorAction == null;
    }

    public Action chooseAction() {
        if (this.getRealized().equals((Object)IntentionStates.FAILED)) {
            return null;
        }
        rnd.setSeed(System.currentTimeMillis());
        if (this.chosenAction == null) {
            if (this.notTriedActions == null) {
                this.notTriedActions = (ArrayList)this.actions.clone();
            }
            this.chosenAction = this.notTriedActions.size() > 0 ? this.notTriedActions.get(rnd.nextInt(this.notTriedActions.size())) : null;
        }
        if (this.chosenAction != null) {
            this.chosenAction.intention = this;
            this.chosenAction.activity = this.activity;
        }
        return this.chosenAction;
    }

    public int compareTo(Object o) {
        Intention int2 = (Intention)o;
        if (int2.activity == this.activity) {
            return 0;
        }
        if (int2.activity > this.activity) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Intention)) {
            return false;
        }
        Intention that = (Intention)aThat;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.activity != that.activity) {
            return false;
        }
        if (!this.realized.equals((Object)that.realized)) {
            return false;
        }
        if (this.ancestorAction != null || that.ancestorAction != null) {
            if (this.ancestorAction == null || this.ancestorAction == null) {
                return false;
            }
            if (!this.ancestorAction.equals(that.ancestorAction)) {
                return false;
            }
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 3 * hash + (this.actions != null ? this.actions.hashCode() : 0);
        hash = 3 * hash + (this.ancestorAction != null ? this.ancestorAction.hashCode() : 0);
        hash = 3 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public int getActivity() {
        return this.activity;
    }

    public void setActivity(int activity) {
        this.activity = activity <= 0 ? 0 : activity;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public IntentionStates getRealized() {
        return this.realized;
    }

    public void setRealized(IntentionStates realized) {
        this.realized = realized;
    }

    public Action getChosenAction() {
        return this.chosenAction;
    }

    public void setChosenAction(Action chosenAction) {
        this.chosenAction = chosenAction;
    }

    public ArrayList<Action> getActions() {
        return this.actions;
    }

    public void setActions(ArrayList<Action> actions) {
        this.actions = actions;
    }

    public ArrayList<Action> getNotTriedActions() {
        return this.notTriedActions;
    }

    public void setNotTriedActions(ArrayList<Action> oldProcesses) {
        this.notTriedActions = oldProcesses;
    }

    public ArrayList<Interval> getActivationIntervals() {
        return this.activationIntervals;
    }

    public void setActivationIntervals(ArrayList<Interval> activationIntervals) {
        this.activationIntervals = activationIntervals;
    }

    public Action getAncestorAction() {
        return this.ancestorAction;
    }

    public void setAncestorAction(Action ancestorAction) {
        this.ancestorAction = ancestorAction;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void increaseDuration() {
        ++this.duration;
    }

    public int getMemoryDuration() {
        return this.memoryDuration;
    }

    public void setMemoryDuration(int memoryDuration) {
        this.memoryDuration = memoryDuration;
    }

    public void setFadeout(int fadeout) {
        this.fadeout = fadeout;
    }

    public int getFadeout() {
        return this.fadeout;
    }

    public void decreaseFadeout() {
        --this.fadeout;
    }

    public int getTimeLimit() {
        if (this.timeLimit != 0) {
            return this.timeLimit;
        }
        int max = 0;
        for (Action action : this.actions) {
            if (action.timeLimit <= max) continue;
            max = action.timeLimit;
        }
        return max;
    }

    public void dropOut(int time) {
        for (Interval interval : this.activationIntervals) {
            if (!interval.isInInterval(time)) continue;
            this.dropoutInterval = new Interval(time, interval.getRightSide(), 0);
        }
    }

    public static Intention exampleOfIntention() {
        Intention result = new Intention();
        HashSet<AffordanceType> affordances = new HashSet<AffordanceType>();
        affordances.add(AffordanceType.TO_CLEAN);
        Interval int1 = new Interval(100, 200, 20);
        Interval int2 = new Interval(500, 700, 50);
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(int2);
        intervals.add(int1);
        result.setActivationIntervals(intervals);
        result.setActivity(10);
        result.setDuration(100);
        result.setMemoryDuration(300);
        result.setRealized(IntentionStates.NO);
        result.setActions(new ArrayList<Action>());
        result.setName("example intention");
        return result;
    }

    public void restrictTimeLimits(int intervalSize) {
        if (this.getTimeLimit() < intervalSize) {
            return;
        }
        for (Action action : this.actions) {
            if (action.timeLimit <= intervalSize) continue;
            if (action.intentions != null && !action.intentions.isEmpty()) {
                for (Intention intention : action.intentions) {
                    intention.restrictTimeLimits(intervalSize);
                }
                continue;
            }
            action.timeLimit = intervalSize * 2 / 3;
        }
        this.timeLimit = intervalSize;
    }
}

