/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.GMTTime;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import utils.TimeUtils;

class DMSModuleViewerInfo
extends JPanel {
    private DecisionModuleImpl module = null;

    public DMSModuleViewerInfo(DecisionModuleImpl module) {
        if (module == null) {
            throw new IllegalArgumentException("DMS is null! " + this.getClass());
        }
        this.module = module;
        this.initComponents();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.module == null) {
            return;
        }
        int x = 10;
        int y = 20;
        int yIncrement = 20;
        g2d.drawString("Plan file: \t" + this.module.agent.planningFilename, x, y);
        if (this.module.actualIntention != null) {
            g2d.drawString("Actual Intention: \t" + this.module.actualIntention.getName(), x, y += yIncrement);
            g2d.drawString("Intention activity: \t" + this.module.actualIntention.getActivity(), x, y += yIncrement);
        } else {
            g2d.drawString("Actual Intention: \tNone", x, y += yIncrement);
            g2d.drawString("Intention activity: \t0", x, y += yIncrement);
        }
        y += yIncrement;
        if (this.module.actualAction != null) {
            g2d.drawString("Actual Action: \t" + this.module.actualAction.name, x, y);
            g2d.drawString("Action activity: \t" + this.module.actualAction.activity, x, y += yIncrement);
        } else {
            g2d.drawString("Actual Action: \tNone", x, y);
            g2d.drawString("Action activity: \t0", x, y += yIncrement);
        }
        g2d.drawString("Counter: \t\t" + this.module.counter, x, y += yIncrement);
        g2d.drawString("Time: \t\t" + TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(this.module.counter)), x, y += yIncrement);
        if (this.module.agent.getLocation() != null) {
            g2d.drawString("Location: \t\t" + this.module.agent.getLocation().toString(), x, y += yIncrement);
        }
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setAutoscrolls(true);
        this.setMaximumSize(new Dimension(400, 300));
        this.setMinimumSize(new Dimension(300, 200));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.getAccessibleContext().setAccessibleName("DMSViewerInfo");
        this.getAccessibleContext().setAccessibleDescription("Displays DMS intern variables.");
    }
}

