/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import atomicActions.AtomicActionFactory;
import decisionMakingSystem.Action;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.Intention;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import utils.StringListWrapper;
import utils.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicIntentionLoader {
    BasicIntentionLoader() {
    }

    public static void createFirstXMLEntry() {
        Intention intention = Intention.exampleOfIntention();
        Action action = Action.exampleAction();
        Action action2 = new Action();
        intention.setActions(new ArrayList<Action>());
        intention.getActions().add(action);
        intention.getActions().add(action2);
        try {
            File file = new File("Intention.xml");
            FileOutputStream outputFile = new FileOutputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Intention.class});
            Marshaller m = context.createMarshaller();
            m.marshal((Object)intention, (OutputStream)outputFile);
        }
        catch (Exception e) {
            System.err.println("Error in creating intention entry! " + e);
        }
    }

    public static void xmlLoaderEntry() {
        StringListWrapper list = new StringListWrapper();
        list.list.add("Intention.xml");
        list.list.add("Eating.xml");
        try {
            File file = new File("Loader.xml");
            FileOutputStream outputFile = new FileOutputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{StringListWrapper.class});
            Marshaller m = context.createMarshaller();
            m.marshal((Object)list, (OutputStream)outputFile);
        }
        catch (Exception e) {
            System.err.println("Error in creating Loader Entry! " + e);
        }
    }

    public static ArrayList<Intention> importIntentionForest(String directory, DecisionModuleImpl module) {
        float time = System.currentTimeMillis();
        ArrayList<Intention> basicIntentions = new ArrayList<Intention>();
        File file = new File(directory + "plans\\Loader.xml");
        StringListWrapper wrapper = null;
        ArrayList<Object> listOfFiles = new ArrayList();
        try {
            FileInputStream reader = new FileInputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{StringListWrapper.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            wrapper = (StringListWrapper)unmarshaller.unmarshal((InputStream)reader);
        }
        catch (Exception e) {
            module.agent.getLogger().user().severe("Error in loading Loader.xml\n" + e);
            System.err.println("Error in loading Loader.xml\n" + e);
        }
        listOfFiles = wrapper.list;
        module.agent.getLogger().user().info("List of root intentions to load: " + listOfFiles);
        Intention tempIntention = null;
        for (String string : listOfFiles) {
            try {
                file = new File(directory + "plans\\" + string);
                FileInputStream reader = new FileInputStream(file);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Intention.class});
                Unmarshaller u = context.createUnmarshaller();
                tempIntention = (Intention)u.unmarshal((InputStream)reader);
                basicIntentions.add(tempIntention);
            }
            catch (Exception e) {
                module.agent.getLogger().user().severe("Error in loading intention: " + string + "\n" + e);
            }
        }
        Object it = null;
        for (Intention individual : basicIntentions) {
            ArrayList<Action> actionsWithAtomicActions = BasicIntentionLoader.getActionsWithAtomicActions(individual, module.log);
            BasicIntentionLoader.retypeAtomicActions(actionsWithAtomicActions, module);
            module.agent.getLogger().user().info("Basic intention: " + individual.getName() + " successfully loaded.");
        }
        time = (float)System.currentTimeMillis() - time;
        module.agent.getLogger().user().info("Intentions loaded in: " + Math.round(time) + "ms");
        return basicIntentions;
    }

    public static void main(String[] args) {
        BasicIntentionLoader.xmlLoaderEntry();
    }

    protected static ArrayList<Action> getActionsWithAtomicActions(Intention individual) {
        ArrayList<Action> result = new ArrayList<Action>();
        if (individual != null && individual.getActions() != null) {
            for (Action action : individual.getActions()) {
                action.timeLimit = TimeUtils.minutesToTicksOfLogic(action.realTimeLimit);
                if (action.atomicActions != null && action.atomicActions.size() > 0) {
                    result.add(action);
                }
                if (action.intentions == null || action.intentions.size() <= 0) continue;
                for (Intention intention : action.intentions) {
                    result.addAll(BasicIntentionLoader.getActionsWithAtomicActions(intention));
                }
            }
        }
        return result;
    }

    protected static ArrayList<Action> getActionsWithAtomicActions(Intention individual, Logger log) {
        ArrayList<Action> result = new ArrayList<Action>();
        if (individual != null && individual.getActions() != null) {
            for (Action action : individual.getActions()) {
                action.timeLimit = TimeUtils.minutesToTicksOfLogic(action.realTimeLimit);
                log.fine("Time limit:" + action.timeLimit + " real time: " + action.realTimeLimit);
                if (action.atomicActions != null && action.atomicActions.size() > 0) {
                    result.add(action);
                }
                if (action.intentions == null || action.intentions.size() <= 0) continue;
                for (Intention intention : action.intentions) {
                    result.addAll(BasicIntentionLoader.getActionsWithAtomicActions(intention, log));
                }
            }
        }
        return result;
    }

    private static void retypeAtomicActions(ArrayList<Action> actionsWithAtomicActions, DecisionModuleImpl module) {
        ArrayList<AtomicAction> actions = null;
        for (Action action : actionsWithAtomicActions) {
            actions = action.atomicActions;
            for (int i = 0; i < actions.size(); ++i) {
                AtomicAction act = actions.get(i);
                actions.remove(i);
                if (act == null || act.type == null) continue;
                act = AtomicActionFactory.getInstace().getAction(act.type, action, module.agent);
                actions.add(i, act);
            }
        }
    }
}

