/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import decisionMakingSystem.Action;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.SearchPocket;

class AtomicSearchPocket
extends AtomicAction {
    DecisionModuleImpl module;

    public AtomicSearchPocket(Action parent, DecisionModuleImpl module) {
        super(parent, module.agent);
        this.module = module;
        this.type = AtomicActions.SEARCH_POCKET;
    }

    public void execute() {
        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString()));
        this.counter = this.agent.getCurrentTime();
    }

    public boolean succeeded() {
        AffordanceType aff = ((SearchPocket)this.parent).affordance;
        EItem item = this.module.inventory.getItemOfAffordance(aff);
        if (item != null) {
            this.module.perceptiveField.satisfyAffordance(this.parent.intention.getAncestorAction(), aff, item);
            this.agent.getLogger().user().info("Atomic search pocket - " + (Object)((Object)aff) + " - finished. Duration :" + this.counter + " rounds.");
            return true;
        }
        return false;
    }

    public boolean failed() {
        return this.counter - this.actionStart > this.parent.timeLimit;
    }

    protected void initialisation() {
        this.actionStart = this.agent.getCurrentTime();
    }
}

