/*
 * Decompiled with CFR 0.152.
 */
package atomicActions;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import decisionMakingSystem.Action;
import episodicbot.EpisBot;
import java.io.Serializable;

public class SitAtTheLecture
extends AtomicAction
implements Serializable {
    private int lastMessageSent = 0;
    private int messageDelay = 20;

    public boolean succeeded() {
        if (this.counter - this.actionStart > this.parent.timeLimit) {
            this.logFinished("End of sitting at the lecture - finaly! Duration: " + this.counter + " rounds");
            return true;
        }
        return false;
    }

    public boolean failed() {
        return false;
    }

    public SitAtTheLecture() {
    }

    public void execute() {
        if (this.counter == 0) {
            this.agent.getLogger().user().info("Sitting at the lecture");
            this.initialisation();
        }
        this.counter = this.agent.getCurrentTime();
        for (Player plr : this.agent.players.getVisiblePlayers().values()) {
            if (!plr.getAction().toUpperCase().contains("SIT_AT_THE_LECTURE")) continue;
            this.agent.getAct().act(new TurnTo().setLocation(plr.getLocation()));
            if (this.counter - this.lastMessageSent <= this.messageDelay) break;
            this.agent.getAct().act(new SendMessage().setText("*STUDY TOGETHER* Another boring lecture. Lets play tic tac toe.").setFadeOut(8.0));
            this.lastMessageSent = this.counter;
            break;
        }
    }

    public SitAtTheLecture(Action parent, EpisBot agent) {
        super(parent, agent);
        this.type = AtomicActions.SIT_AT_THE_LECTURE;
    }

    protected void initialisation() {
        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString()));
        this.actionStart = this.agent.getCurrentTime();
    }
}

