/*
 * Decompiled with CFR 0.152.
 */
package atomicActions;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Shoot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import decisionMakingSystem.Action;
import decisionMakingSystem.AffordanceType;
import episodicbot.EpisBot;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ShootPrey
extends AtomicAction
implements Serializable {
    private Player target = null;
    private boolean failed = false;
    private double score = 0.0;

    public void execute() {
        if (this.counter == 0) {
            this.agent.getLogger().user().info("Shooting prey");
            this.initialisation();
        }
        this.counter = this.agent.getCurrentTime();
        if (this.target == null) {
            this.failed = true;
            return;
        }
        this.agent.getAct().act(new Shoot().setLocation(this.target.getLocation()));
    }

    public boolean succeed() {
        if (this.score < this.agent.getAgentScore()) {
            this.agent.getAct().act(new StopShooting());
            this.logFinished("prey hunted down!");
            return true;
        }
        return false;
    }

    public boolean failed() {
        if (this.agent.getAgentAmmo() == 0) {
            this.failed = true;
        }
        if (this.counter - this.actionStart > this.parent.timeLimit) {
            this.failed = true;
        }
        return this.failed;
    }

    public ShootPrey(Action parent, EpisBot agent) {
        super(parent, agent);
        this.type = AtomicActions.SHOOT_PREY;
    }

    public boolean succeeded() {
        return this.agent.getAgentScore() > this.score;
    }

    protected void initialisation() {
        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString()));
        this.actionStart = this.agent.getCurrentTime();
        this.score = this.agent.getAgentScore();
        if (this.parent.satisfyingItems.get((Object)AffordanceType.TO_SHOOT_AT) != null) {
            this.target = (Player)this.parent.satisfyingItems.get((Object)((Object)AffordanceType.TO_SHOOT_AT)).item;
        } else {
            this.agent.getLogger().user().severe("Unsatisfied affordance! no prey to shoot!");
            this.failed = true;
        }
    }
}

